package com.xebialabs.plugin.manager.config

import com.xebialabs.plugin.manager.metadata.XLProduct
import com.xebialabs.plugin.manager.metadata.XLProduct.{XLDeploy, XLRelease}

import scala.util.matching.Regex

object ConfigWrapper {
  val EXTENSION_XLDP: String = "xldp"
  val EXTENSION_JAR: String = "jar"
  val EXTENSION_ZIP: String = "zip"
  val GROUP_ID_XLD: String = "com.xebialabs.deployit.plugins"
  val GROUP_ID_XLR: String = "com.xebialabs.xlrelease.plugins"

  private var extensions: Set[String] = _
  private lazy val extensionsPattern: String = ConfigWrapper.getExtensions().mkString("|")
  private lazy val extensionsRegex: Regex = raw""".*\.($extensionsPattern)""".r
  private var groupId: String = _

  def initWith(product: XLProduct): Unit = {
    product match {
      case XLDeploy =>
        extensions = Set(EXTENSION_XLDP)
        groupId = GROUP_ID_XLD
      case XLRelease =>
        extensions = Set(EXTENSION_JAR, EXTENSION_ZIP)
        groupId = GROUP_ID_XLR
      case other => throw new IllegalArgumentException(s"Unknown product name: '$other'")
    }
  }

  def getExtensions(): Set[String] = extensions
  def getGroupId(): String = groupId
  def getAnyExtensionsRegexPattern(): String = extensionsPattern

  def isValidExtension(filename: String): Boolean = {
    filename match {
      case extensionsRegex(_) => true
      case _ => false
    }
  }

  def getValidExtension(filename: String): Option[String] = {
    filename match {
      case extensionsRegex(extension) => Some(extension)
      case _ => None
    }
  }
}