package com.xebialabs.plugin.manager.metadata

import com.xebialabs.plugin.manager.PluginId
import org.apache.pekko.http.scaladsl.marshallers.sprayjson.SprayJsonSupport
import spray.json._

case class MetadataEntry(artifactId: ArtifactId, metadata: ExtendedMetadata)

object MetadataEntry {
  trait Protocol extends SprayJsonSupport with DefaultJsonProtocol
    with ArtifactId.Protocol
    with ExtendedMetadata.Protocol
    with PluginId.Protocol
    with Version.Protocol
    with VersionExpr.Protocol {

    val metadataEntryReader: RootJsonReader[MetadataEntry] = {
      case obj: JsObject =>
        obj.getFields("id", "metadata") match {
          case Seq(pluginId, metadata) =>
            MetadataEntry(pluginId.convertTo[ArtifactId], metadata.convertTo[ExtendedMetadata])
          case other =>
            deserializationError(s"Cannot parse MetadataEntry: $other")
        }
      case unknown =>
        deserializationError(s"Cannot parse MetadataEntry: $unknown")
    }
    val metadataEntryWriter: RootJsonWriter[MetadataEntry] = entry => JsObject(
      "id" -> entry.artifactId.toJson,
      "metadata" -> entry.metadata.toJson
    )
    implicit val metadataEntryFormat: RootJsonFormat[MetadataEntry] = rootJsonFormat(metadataEntryReader, metadataEntryWriter)
  }
}
