/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.model;

import com.xebialabs.plugin.manager.Plugin;
import com.xebialabs.plugin.manager.PluginId;
import com.xebialabs.plugin.manager.metadata.Version;
import com.xebialabs.plugin.manager.metadata.Version$;
import com.xebialabs.plugin.manager.metadata.Version$VersionOps$;
import com.xebialabs.plugin.manager.model.DbPlugin;
import com.xebialabs.plugin.manager.rest.api.PluginSource$;
import com.xebialabs.plugin.manager.rest.api.PluginStatus$;
import com.xebialabs.plugin.manager.util.ChecksumUtil$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple10;
import scala.runtime.ModuleSerializationProxy;

public final class DbPlugin$
implements Serializable {
    public static final DbPlugin$ MODULE$ = new DbPlugin$();

    public DbPlugin apply(Plugin plugin) {
        PluginId pluginId = plugin.id();
        if (pluginId instanceof PluginId.Artifact) {
            PluginId.Artifact artifact = (PluginId.Artifact)pluginId;
            return this.fromArtifact(artifact, plugin.bytes());
        }
        if (pluginId instanceof PluginId.LocalFile) {
            PluginId.LocalFile localFile = (PluginId.LocalFile)pluginId;
            return this.fromLocalFile(localFile, plugin.bytes());
        }
        throw new IllegalArgumentException("Not a proper plugin for conversion to a dbPlugin");
    }

    public DbPlugin fromLocalFile(PluginId.LocalFile localFile, byte[] bytes) {
        return new DbPlugin("0", localFile.name(), (Option<String>)new Some(localFile.version().map((Function1 & Serializable)v -> Version$VersionOps$.MODULE$.id$extension(Version$.MODULE$.VersionOps((Version)v))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), localFile.extension(), PluginSource$.MODULE$.LOCAL().toString(), PluginStatus$.MODULE$.READY_FOR_INSTALL(), PluginSource$.MODULE$.LOCAL(), ChecksumUtil$.MODULE$.calculateChecksum(bytes), (Option<Object>)None$.MODULE$, (Option<byte[]>)new Some((Object)bytes));
    }

    public DbPlugin fromArtifact(PluginId.Artifact artifact, byte[] bytes) {
        return new DbPlugin("0", artifact.artifactId(), (Option<String>)artifact.version().map((Function1 & Serializable)x$1 -> Version$VersionOps$.MODULE$.id$extension(Version$.MODULE$.VersionOps((Version)x$1))), artifact.packaging(), artifact.groupId(), PluginStatus$.MODULE$.READY_FOR_INSTALL(), PluginSource$.MODULE$.withName(artifact.repository()), ChecksumUtil$.MODULE$.calculateChecksum(bytes), (Option<Object>)None$.MODULE$, (Option<byte[]>)new Some((Object)bytes));
    }

    public DbPlugin DbPluginOps(DbPlugin dbPlugin) {
        return dbPlugin;
    }

    public DbPlugin apply(String id, String name, Option<String> version, String extension, String groupId, Enumeration.Value installationStatus, Enumeration.Value source, String checksum, Option<Object> pluginBytesId, Option<byte[]> bytes) {
        return new DbPlugin(id, name, version, extension, groupId, installationStatus, source, checksum, pluginBytesId, bytes);
    }

    public Option<Tuple10<String, String, Option<String>, String, String, Enumeration.Value, Enumeration.Value, String, Option<Object>, Option<byte[]>>> unapply(DbPlugin x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple10((Object)x$0.id(), (Object)x$0.name(), x$0.version(), (Object)x$0.extension(), (Object)x$0.groupId(), (Object)x$0.installationStatus(), (Object)x$0.source(), (Object)x$0.checksum(), x$0.pluginBytesId(), x$0.bytes()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DbPlugin$.class);
    }

    private DbPlugin$() {
    }
}

