/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.repository.storage;

import com.xebialabs.plugin.manager.LocalPluginManager$;
import com.xebialabs.plugin.manager.PluginId;
import com.xebialabs.plugin.manager.PluginId$Artifact$;
import com.xebialabs.plugin.manager.PluginId$Artifact$ArtifactOps$;
import com.xebialabs.plugin.manager.metadata.ArtifactId;
import com.xebialabs.plugin.manager.metadata.ArtifactId$;
import com.xebialabs.plugin.manager.metadata.ArtifactId$ArtifactIdOps$;
import com.xebialabs.plugin.manager.metadata.ExtendedMetadata;
import com.xebialabs.plugin.manager.metadata.PluginMetadata;
import com.xebialabs.plugin.manager.repository.storage.PluginMetadataStorage;
import com.xebialabs.xlplatform.io.ZipUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.slf4j.Marker;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005-d\u0001B\t\u0013\u0001}A\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005i!)\u0001\t\u0001C\u0001\u0003\"9A\t\u0001b\u0001\n#)\u0005B\u0002)\u0001A\u0003%a\tC\u0004R\u0001\t\u0007I\u0011\u0003*\t\r\u0011\u0004\u0001\u0015!\u0003T\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007Aq!!\n\u0001\t\u0003\n9\u0003C\u0004\u00024\u0001!\t%!\u000e\t\u000f\u0005M\u0002\u0001\"\u0001\u0002H!9\u00111\n\u0001\u0005B\u00055\u0003bBA,\u0001\u0011E\u0011\u0011\f\u0005\b\u0003O\u0002A\u0011CA5\u0005m\u0001F.^4j]6+G/\u00193bi\u0006lU-\\8ssN#xN]1hK*\u00111\u0003F\u0001\bgR|'/Y4f\u0015\t)b#\u0001\u0006sKB|7/\u001b;pefT!a\u0006\r\u0002\u000f5\fg.Y4fe*\u0011\u0011DG\u0001\u0007a2,x-\u001b8\u000b\u0005ma\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0012aA2p[\u000e\u00011\u0003\u0002\u0001!M)\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0007CA\u0014)\u001b\u0005\u0011\u0012BA\u0015\u0013\u0005U\u0001F.^4j]6+G/\u00193bi\u0006\u001cFo\u001c:bO\u0016\u0004\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\u000bMdg\r\u000e6\u000b\u0003=\n\u0001b\u001a:jujdW\rZ\u0005\u0003c1\u0012q\u0001T8hO&tw-\u0001\bsKB|7/\u001b;peft\u0015-\\3\u0016\u0003Q\u0002\"!\u000e\u001f\u000f\u0005YR\u0004CA\u001c#\u001b\u0005A$BA\u001d\u001f\u0003\u0019a$o\\8u}%\u00111HI\u0001\u0007!J,G-\u001a4\n\u0005ur$AB*ue&twM\u0003\u0002<E\u0005y!/\u001a9pg&$xN]=OC6,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\u0005\u000e\u0003\"a\n\u0001\t\u000bI\u001a\u0001\u0019\u0001\u001b\u0002\u0011\r\f7\r[3ESJ,\u0012A\u0012\t\u0003\u000f:k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bAAZ5mK*\u00111\nT\u0001\u0004]&|'\"A'\u0002\t)\fg/Y\u0005\u0003\u001f\"\u0013A\u0001U1uQ\u0006I1-Y2iK\u0012K'\u000fI\u0001\u0007[\u0016lwN]=\u0016\u0003M\u0003B\u0001V-\\C6\tQK\u0003\u0002W/\u00069Q.\u001e;bE2,'B\u0001-#\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00035V\u00131!T1q!\tav,D\u0001^\u0015\tqf#\u0001\u0005nKR\fG-\u0019;b\u0013\t\u0001WL\u0001\u0006BeRLg-Y2u\u0013\u0012\u0004\"\u0001\u00182\n\u0005\rl&A\u0004)mk\u001eLg.T3uC\u0012\fG/Y\u0001\b[\u0016lwN]=!\u0003\u0015\u0019G.Z1s)\u00059\u0007CA\u0011i\u0013\tI'E\u0001\u0003V]&$\u0018AC:u_J,Gj\\4pgR\u0011AN \u000b\u0003[Z\u00042A\\:5\u001d\ty\u0017O\u0004\u00028a&\t1%\u0003\u0002sE\u00059\u0001/Y2lC\u001e,\u0017B\u0001;v\u0005\r\u0019V-\u001d\u0006\u0003e\nBQa^\u0005A\u0002a\fA\u0001Z1uCB\u0011\u0011\u0010`\u0007\u0002u*\u00111\u0010T\u0001\u0003S>L!! >\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\u0006\u007f&\u0001\r!\\\u0001\fCJ$\u0018NZ1di&#7/A\u0003ti>\u0014X\rF\u0003h\u0003\u000b\tI\u0002\u0003\u0004x\u0015\u0001\u0007\u0011q\u0001\t\u0005]N\fI\u0001\u0005\u0003\u0002\f\u0005Ma\u0002BA\u0007\u0003\u001fi\u0011AF\u0005\u0004\u0003#1\u0012\u0001\u0003)mk\u001eLg.\u00133\n\t\u0005U\u0011q\u0003\u0002\t\u0003J$\u0018NZ1di*\u0019\u0011\u0011\u0003\f\t\ryS\u0001\u0019AA\u000e!\u0019)\u0014QD.\u0002 %\u0011!L\u0010\t\u00049\u0006\u0005\u0012bAA\u0012;\n\u0001R\t\u001f;f]\u0012,G-T3uC\u0012\fG/Y\u0001\u0004O\u0016$H\u0003BA\u0015\u0003_\u0001B!IA\u0016C&\u0019\u0011Q\u0006\u0012\u0003\r=\u0003H/[8o\u0011\u0019\t\td\u0003a\u00017\u0006\u0011\u0011\u000eZ\u0001\bO\u0016$Hj\\4p)\u0019\t9$a\u0010\u0002DA)\u0011%a\u000b\u0002:A\u0019\u00110a\u000f\n\u0007\u0005u\"P\u0001\u0003GS2,\u0007BBA!\u0019\u0001\u0007A'A\u0004he>,\b/\u00133\t\r\u0005\u0015C\u00021\u00015\u0003)\t'\u000f^5gC\u000e$\u0018\n\u001a\u000b\u0005\u0003o\tI\u0005\u0003\u0004\u0002F5\u0001\r\u0001N\u0001\u0007g\u0016\f'o\u00195\u0015\t\u0005=\u0013\u0011\u000b\t\u0007k\u0005u1,!\u000b\t\u000f\u0005Mc\u00021\u0001\u0002V\u0005)\u0011/^3ssB!\u0011%a\u000b5\u0003\u0015iWM]4f)\u0019\tY&a\u0019\u0002fA!an]A/!\u0015\t\u0013qL.b\u0013\r\t\tG\t\u0002\u0007)V\u0004H.\u001a\u001a\t\r]|\u0001\u0019AA\u0004\u0011\u0019qv\u00021\u0001\u0002\u001c\u0005A!/Z1e_:d\u00170\u0006\u0002\u0002P\u0001")
public class PluginMetadataMemoryStorage
implements PluginMetadataStorage,
Logging {
    private final String repositoryName;
    private final Path cacheDir;
    private final Map<ArtifactId, PluginMetadata> memory;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Option<PluginMetadata> get(PluginId.Artifact id) {
        return PluginMetadataStorage.get$(this, id);
    }

    @Override
    public scala.collection.immutable.Map<ArtifactId, Option<PluginMetadata>> list() {
        return PluginMetadataStorage.list$(this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PluginMetadataMemoryStorage pluginMetadataMemoryStorage = this;
        synchronized (pluginMetadataMemoryStorage) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public String repositoryName() {
        return this.repositoryName;
    }

    public Path cacheDir() {
        return this.cacheDir;
    }

    public Map<ArtifactId, PluginMetadata> memory() {
        return this.memory;
    }

    @Override
    public synchronized void clear() {
        this.memory().clear();
    }

    @Override
    public synchronized Seq<String> storeLogos(Seq<String> artifactIds, InputStream data) {
        File dir = this.cacheDir().resolve(this.repositoryName()).toFile();
        FileUtils.deleteDirectory((File)dir);
        return ZipUtils$.MODULE$.collect(data, dir, (PartialFunction)new Serializable(null, artifactIds){
            private static final long serialVersionUID = 0L;
            private final Seq artifactIds$1;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (this.artifactIds$1.contains((Object)StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(A1), 4))) {
                    return (B1)StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(A1), 4);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                return this.artifactIds$1.contains((Object)StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(string), 4));
            }
            {
                this.artifactIds$1 = artifactIds$1;
            }
        });
    }

    @Override
    public void store(Seq<PluginId.Artifact> data, scala.collection.immutable.Map<ArtifactId, ExtendedMetadata> metadata) {
        PluginMetadataMemoryStorage pluginMetadataMemoryStorage = this;
        synchronized (pluginMetadataMemoryStorage) {
            this.memory().clear();
            Map cfr_ignored_0 = (Map)this.memory().$plus$plus$eq(this.merge(data, metadata));
        }
    }

    @Override
    public Option<PluginMetadata> get(ArtifactId id) {
        return this.memory().get((Object)id);
    }

    @Override
    public synchronized Option<File> getLogo(String groupId, String artifactId) {
        boolean metadataExists = this.memory().keys().exists((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)PluginMetadataMemoryStorage.$anonfun$getLogo$1(groupId, artifactId, a)));
        if (metadataExists) {
            return this.getLogo(artifactId);
        }
        this.logger().debug((Function0 & Serializable)() -> "No logo found for artifactId: " + artifactId + " and groupId: " + groupId);
        return None$.MODULE$;
    }

    public Option<File> getLogo(String artifactId) {
        Path dir = this.cacheDir().resolve(this.repositoryName());
        this.logger().debug((Function0 & Serializable)() -> "search logo data for " + artifactId + " in " + dir);
        if (dir.toFile().isDirectory()) {
            return LocalPluginManager$.MODULE$.listDir(dir).find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PluginMetadataMemoryStorage.$anonfun$getLogo$4(artifactId, x$1))).map((Function1 & Serializable)x$2 -> x$2.toFile());
        }
        this.logger().debug((Function0 & Serializable)() -> "not a directory: " + ((Object)dir).toString());
        return None$.MODULE$;
    }

    @Override
    public scala.collection.immutable.Map<ArtifactId, Option<PluginMetadata>> search(Option<String> query) {
        Some some;
        String name;
        Option<String> option = query;
        if (option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(name = (String)(some = (Some)option).value()))) {
            return this.readonly().view().filterKeys((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)PluginMetadataMemoryStorage.$anonfun$search$1(name, x$3))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return this.readonly();
    }

    public Seq<Tuple2<ArtifactId, PluginMetadata>> merge(Seq<PluginId.Artifact> data, scala.collection.immutable.Map<ArtifactId, ExtendedMetadata> metadata) {
        return data.groupBy((Function1 & Serializable)x$4 -> PluginId$Artifact$ArtifactOps$.MODULE$.toArtifactId$extension(PluginId$Artifact$.MODULE$.ArtifactOps((PluginId.Artifact)x$4))).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)PluginMetadataMemoryStorage.$anonfun$merge$2(check$ifrefutable$1))).withFilter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)PluginMetadataMemoryStorage.$anonfun$merge$3(x$5))).flatMap((Function1 & Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 != null) {
                ArtifactId artifactId = (ArtifactId)tuple2._1();
                return metadata.get((Object)artifactId).map((Function1 & Serializable)meta -> {
                    boolean hasLogo = this.getLogo(artifactId.artifactId()).isDefined();
                    return new Tuple2(meta, (Object)BoxesRunTime.boxToBoolean((boolean)hasLogo));
                }).map((Function1 & Serializable)x$6 -> {
                    Tuple2 tuple2 = x$6;
                    if (tuple2 != null) {
                        ExtendedMetadata meta = (ExtendedMetadata)tuple2._1();
                        boolean hasLogo = tuple2._2$mcZ$sp();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)artifactId), (Object)new PluginMetadata(meta, hasLogo));
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple2);
        }).toSeq();
    }

    public scala.collection.immutable.Map<ArtifactId, Option<PluginMetadata>> readonly() {
        return this.memory().view().mapValues((Function1 & Serializable)value -> new Some(value)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ boolean $anonfun$getLogo$1(String groupId$1, String artifactId$1, ArtifactId a) {
        return a.groupId().equals(groupId$1) && a.artifactId().equals(artifactId$1);
    }

    public static final /* synthetic */ boolean $anonfun$getLogo$4(String artifactId$2, Path x$1) {
        return ((Object)x$1.getFileName()).toString().startsWith(artifactId$2 + ".");
    }

    public static final /* synthetic */ boolean $anonfun$search$1(String name$1, ArtifactId x$3) {
        ArtifactId qual$1 = ArtifactId$.MODULE$.ArtifactIdOps(x$3);
        Option<String> x$1 = ArtifactId$ArtifactIdOps$.MODULE$.toPluginId$default$1$extension(qual$1);
        return ArtifactId$ArtifactIdOps$.MODULE$.toPluginId$extension(qual$1, x$1).name().contains(name$1);
    }

    public static final /* synthetic */ boolean $anonfun$merge$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$merge$3(Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 != null) {
            Seq group = (Seq)tuple2._2();
            return group.nonEmpty();
        }
        throw new MatchError((Object)tuple2);
    }

    public PluginMetadataMemoryStorage(String repositoryName) {
        this.repositoryName = repositoryName;
        PluginMetadataStorage.$init$(this);
        Logging.$init$((Logging)this);
        this.cacheDir = Paths.get("cache", new String[0]).resolve("plugins");
        this.memory = (Map)Map$.MODULE$.empty();
    }
}

