package com.xebialabs.plugin.manager.validator

object TypeSystemValidationResults {
  def apply(): TypeSystemValidationResults = new TypeSystemValidationResults(Seq.empty, false, Seq.empty, Seq.empty)
}

class TypeSystemValidationResults(val messages: Seq[String], val restartRequired: Boolean, val warnings: Seq[String], val errors: Seq[String]) {
  def ++(that: TypeSystemValidationResults): TypeSystemValidationResults = {
    new TypeSystemValidationResults(
      this.messages ++ that.messages,
      this.restartRequired | that.restartRequired,
      this.warnings ++ that.warnings,
      this.errors ++ that.errors
    )
  }

  def failed(): Boolean = {
    errors.nonEmpty
  }

  def succeeded(): Boolean = {
    errors.isEmpty
  }
}

class SuccessfulTypeSystemValidation(val message: String, override val restartRequired: Boolean, override val warnings: Seq[String])
  extends TypeSystemValidationResults(Seq(message), restartRequired, warnings, Seq.empty)

class FailedTypeSystemValidation(val message: String, override val warnings: Seq[String], override val errors: Seq[String])
  extends TypeSystemValidationResults(Seq(message), false, warnings, errors)

case class RestartNeeded(plugin: String, override val warnings: Seq[String])
  extends SuccessfulTypeSystemValidation(s"Plugin $plugin requires a restart.", true, warnings)

case class RestartNotNeeded(plugin: String, override val warnings: Seq[String])
  extends SuccessfulTypeSystemValidation(s"Plugin $plugin does not require restart.", false, warnings)

case class UnableToCreateTypeSystem(override val message: String, override val warnings: Seq[String], override val errors: Seq[String])
  extends FailedTypeSystemValidation(message, warnings, errors)

case class UnsupportedPluginType(override val message: String, override val warnings: Seq[String], override val errors: Seq[String])
  extends FailedTypeSystemValidation(message, warnings, errors)
