package com.xebialabs.plugin.manager.metadata

import org.apache.pekko.http.scaladsl.marshallers.sprayjson.SprayJsonSupport
import org.apache.pekko.http.scaladsl.model.Uri
import spray.json._

case class ExternalLink(name: String, url: Uri)

object ExternalLink {
  trait Protocol extends SprayJsonSupport with DefaultJsonProtocol {
    val externalLinkReader: JsonReader[ExternalLink] = jsonReader[ExternalLink] {
      case obj: JsObject =>
        obj.getFields("name", "url") match {
          case Seq(JsString(name), JsString(url)) =>
            ExternalLink(name, Uri(url))
          case other =>
            deserializationError(s"Cannot parse link: '$other'")
        }
      case unknown =>
        deserializationError(s"Cannot parse link: '$unknown'")
    }
    val externaLinkWriter: JsonWriter[ExternalLink] = jsonWriter[ExternalLink] {
      case ExternalLink(name, url) =>
        JsObject(
          "name" -> name.toJson,
          "url" -> url.toString.toJson
        )
    }
    implicit val externalLinkFormat: JsonFormat[ExternalLink] = jsonFormat(externalLinkReader, externaLinkWriter)
  }
}
