package com.xebialabs.deployit.repository;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.service.validation.Validator;

import java.util.List;

public class RepositoryAdapter implements Repository {
    private RepositoryService repositoryService;
    private Validator validator;
    private WorkDir workDir;

    public RepositoryAdapter(RepositoryService repositoryService, Validator validator, WorkDir workDir) {
        this.repositoryService = repositoryService;
        this.validator = validator;
        this.workDir = workDir;
    }

    @Override
    public boolean exists(String id) {
        return repositoryService.exists(id);
    }

    @Override
    public <T extends ConfigurationItem> T read(String id) {
        return repositoryService.<T>read(id, workDir);
    }

    @Override
    public <T extends ConfigurationItem> void create(T... entity) {
        validator.validateCis(Lists.<ConfigurationItem>newArrayList(entity));
        repositoryService.create(entity);
    }

    @Override
    public <T extends ConfigurationItem> void update(T... entity) {
        validator.validateCis(Lists.<ConfigurationItem>newArrayList(entity));
        repositoryService.update(entity);
    }

    @Override
    public <T extends ConfigurationItem> void createOrUpdate(T... entity) {
        validator.validateCis(Lists.<ConfigurationItem>newArrayList(entity));
        repositoryService.createOrUpdate(entity);
    }

    @Override
    public void delete(String... id) {
        repositoryService.delete(id);
    }

    @Override
    public void move(String id, String newId) {
        repositoryService.move(id, newId);
    }

    @Override
    public void rename(String id, String newName) {
        repositoryService.rename(id, newName);
    }

    @Override
    public <T extends ConfigurationItem> List<T> search(Type type) {
        return repositoryService.listEntities(new SearchParameters().setType(type));
    }

    @Override
    public <T extends ConfigurationItem> List<T> search(Type type, String parent) {
        return repositoryService.listEntities(new SearchParameters().setType(type).setParent(parent));
    }
}
