package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import java.util.List;

/**
 * CRUDL for RepositoryEntity and things extending...
 */
public interface RepositoryService {

    boolean exists(String id);

    <T extends ConfigurationItem> T read(String id);

    <T extends ConfigurationItem> T read(String id, int depth);

    <T extends ConfigurationItem> T read(String id, WorkDir workDir);

    <T extends ConfigurationItem> T read(String id, boolean useCache);

    <T extends ConfigurationItem> T read(String id, WorkDir workDir, boolean useCache);

    <T extends ConfigurationItem> T read(String id, int depth, WorkDir workDir, boolean useCache);

    List<ConfigurationItemData> list(SearchParameters criteria);

    List<ConfigurationItemData> list(QueryTemplate queryTemplate);

    <T extends ConfigurationItem> List<T> listEntities(SearchParameters parameters);

    <T extends ConfigurationItem> List<T> listEntities(QueryTemplate queryTemplate);

    @SuppressWarnings("unchecked")
    <T extends ConfigurationItem> void create(T... entity);

    @SuppressWarnings("unchecked")
    <T extends ConfigurationItem> void update(T... entity);

    @SuppressWarnings("unchecked")
    <T extends ConfigurationItem> void createOrUpdate(T... entity);

    <T extends ConfigurationItem> void move(String id, String newId);

    <T extends ConfigurationItem> void copy(String id, String newId);

    void rename(String id, String newName);

    void delete(String... id);

    void execute(ChangeSet changeset);

    void checkReferentialIntegrity(ChangeSet changeset) throws ItemInUseException, ItemAlreadyExistsException;

    QueryTemplateFactory getQueryTemplateFactory();
}
