package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.overthere.local.LocalFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;

@Component
public class RepositoryAdapterFactory implements RepositoryFactory {

    private final RepositoryService repositoryService;
    private final Validator validator;

    @Autowired
    public RepositoryAdapterFactory(RepositoryService repositoryService, Validator validator) {
        this.repositoryService = repositoryService;
        this.validator = validator;
    }

    @Override
    public Repository create() {
        return new RepositoryAdapter(repositoryService, validator, null);
    }

    @Override
    public Repository create(File temporaryWorkDir) {
        return new RepositoryAdapter(repositoryService, validator, new WorkDir((LocalFile) LocalFile.valueOf(temporaryWorkDir)));
    }
}
