package com.xebialabs.deployit.repository.defaults

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.repository.{RepositoryServiceHolder, SearchParameters}

import scala.collection.convert.ImplicitConversions._

abstract class DefaultEntityResolver[T <: ConfigurationItem](resolvedTypeName: String) {

  def resolveDefaultValue: Option[T]

  val resolvedType: Type = Type.valueOf(resolvedTypeName)
}

abstract class DefaultNamedEntityResolver[T <: ConfigurationItem](resolvedTypeName: String, defaultEntityName: String) extends DefaultEntityResolver[T](resolvedTypeName) {

  def resolveDefaultValue: Option[T]= {
    RepositoryServiceHolder.getRepositoryService.listEntities(new SearchParameters().setType(resolvedType).setName(defaultEntityName)).headOption
  }
}