package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.engine.api.dto.ConfigurationItemIdAndReferenceId;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData;

import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * CRUDL for RepositoryEntity and things extending...
 */
public interface RepositoryService {

    boolean exists(String id);

    Set<String> selectExistingPaths(Set<String> ids);

    default <T extends ConfigurationItem> T readByReferenceId(String referenceId) {
        return this.readByReferenceId(referenceId, Integer.MAX_VALUE, null, true);
    }

    default <T extends ConfigurationItem> T read(String id) {
        return this.read(id, Integer.MAX_VALUE, null, true);
    }

    default <T extends ConfigurationItem> T read(String id, int depth) {
        return this.read(id, depth, null, true);
    }

    default <T extends ConfigurationItem> T read(String id, WorkDir workDir) {
        return this.read(id, Integer.MAX_VALUE, workDir, true);
    }

    default <T extends ConfigurationItem> T read(String id, boolean useCache) {
        return this.read(id, Integer.MAX_VALUE, null, useCache);
    }

    default <T extends ConfigurationItem> T read(String id, WorkDir workDir, boolean useCache) {
        return this.read(id, Integer.MAX_VALUE, workDir, useCache);
    }

    default <T extends ConfigurationItem> T readByReferenceId(String referenceId, int depth, WorkDir workDir, boolean useCache) {
        return this.readByReferenceId(referenceId, depth, workDir, useCache, true);
    }

    default <T extends ConfigurationItem> T read(String id, int depth, WorkDir workDir, boolean useCache) {
        return this.read(id, depth, workDir, useCache, true);
    }

    <T extends ConfigurationItem> T readByReferenceId(String referenceId, int depth, WorkDir workDir, boolean useCache, boolean decryptPasswords);

    <T extends ConfigurationItem> T read(String id, int depth, WorkDir workDir, boolean useCache, boolean decryptPasswords);

    <T extends ConfigurationItem> List<T> read(List<String> ids, int depth, boolean useCache, boolean decryptPasswords, boolean skipNotExistingCis);

    default <T extends ConfigurationItem> List<T> read(List<String> ids, int depth, boolean useCache) {
        return read(ids, depth, useCache, true, true);
    }

    default <T extends ConfigurationItem> List<T> read(List<String> ids, int depth) {
        return read(ids, depth, true);
    }

    List<ConfigurationItemData> list(SearchParameters criteria);

    List<ConfigurationItemIdAndReferenceId> listWithReferenceId(SearchParameters parameters);

    long count(SearchParameters criteria);

    <T extends ConfigurationItem> List<T> listEntities(SearchParameters parameters);

    <T extends ConfigurationItem> List<T> listEntities(SearchParameters parameters, int depth, boolean useCache);

    @SuppressWarnings("unchecked")
    <T extends ConfigurationItem> void create(T... entity);

    <T extends ConfigurationItem> void createCis(List<T> entities, SCMTraceabilityData scmTraceabilityData);

    @SuppressWarnings("unchecked")
    <T extends ConfigurationItem> void update(T... entity);

    @SuppressWarnings("unchecked")
    <T extends ConfigurationItem> void updateCis(List<T> entities, SCMTraceabilityData scmTraceabilityData);

    @SuppressWarnings("unchecked")
    <T extends ConfigurationItem> void createOrUpdate(T... entity);

    @SuppressWarnings("unchecked")
    <T extends ConfigurationItem> void createOrUpdateCis(List<T> entities, SCMTraceabilityData scmTraceabilityData);

    <T extends ConfigurationItem> void move(String id, String newId);

    <T extends ConfigurationItem> void copy(String id, String newId);

    void rename(String id, String newName);

    void delete(String... id);

    void execute(ChangeSet changeset);

    void execute(ChangeSet changeset, ProgressLogger progressLogger);

    void checkReferentialIntegrity(ChangeSet changeset) throws ItemInUseException, ItemAlreadyExistsException;

    default <T extends ConfigurationItem> void createCollection(Collection<T> entities) {
        create(entities.toArray(new ConfigurationItem[entities.size()]));
    }

    default <T extends ConfigurationItem> void createOrUpdateCollection(Collection<T> entities) {
        createOrUpdate(entities.toArray(new ConfigurationItem[entities.size()]));
    }

    default <T extends ConfigurationItem> void updateCollection(Collection<T> entities) {
        update(entities.toArray(new ConfigurationItem[entities.size()]));
    }

    default void deleteCollection(Collection<String> entities) {
        delete(entities.toArray(new String[entities.size()]));
    }

}
