package com.xebialabs.deployit.service.externalproperties;

import com.xebialabs.deployit.plugin.api.udm.ExternalProperty;

/**
 * Interface for resolving {@link ExternalProperty external values} for {@link com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem}s
 *
 * @see com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem#get$externalProperties
 */
public interface ExternalValueProvider {

    /**
     * Can this provider resolve a value (e.g. is it currently available)
     */
    boolean isProviderAvailable(ExternalProperty externalProperty);

    /**
     * Can this provider provide a value for the property?
     */
    boolean supports(ExternalProperty externalProperty);

    /**
     * Resolve a value for an {@link ExternalProperty}
     * @param externalProperty The external property to resolve
     * @param password Whether the property will be used for a password property.
     * @return The value found. Can return <code>null</code> if non value was found.
     * @throws IllegalExternalPropertyReferenceException when the provider refuses to provide a value for this call, e.g. when a secret is resolved for a non password field.
     */
    Object resolve(ExternalProperty externalProperty, boolean password) throws IllegalExternalPropertyReferenceException;
}
