package com.xebialabs.deployit.repository;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.atomic.AtomicReference;

@Component
public class RepositoryServiceHolder {

    private static final AtomicReference<RepositoryService> repositoryService = new AtomicReference<>();

    @Autowired
    public RepositoryServiceHolder(RepositoryService repositoryService) {
        RepositoryServiceHolder.repositoryService.set(repositoryService);
    }

    public static RepositoryService getRepositoryService() {
        return RepositoryServiceHolder.repositoryService.get();
    }
}
