package com.xebialabs.xlplatform.repository.sql.db

import com.xebialabs.xlplatform.repository.sql.Database
import com.xebialabs.xlplatform.repository.sql.db.MetadataSchema.METADATA
import slick.jdbc.JdbcProfile

object MetadataSchema {

  abstract class Table(val TABLE: String)

  object METADATA extends Table("XL_METADATA") {
    val name: String = "NAME"

    val value: String = "VALUE"
  }

}

object Tables {

  lazy val profile: JdbcProfile = Database.databaseType.profile

  import profile.api._

  case class Metadata(name: String, value: String)

  class MetadataTable(tag: Tag) extends Table[Metadata](tag, METADATA.TABLE) {

    def name = column[String](METADATA.name, O.PrimaryKey)

    def value = column[String](METADATA.value)

    def * = (name, value) <> (Metadata.tupled, Metadata.unapply)
  }

  val metadata = TableQuery[MetadataTable]
}