package com.xebialabs.xlplatform.xlrepository.tck

import java.io.File

import com.xebialabs.deployit.repository.RepositoryMetadataService
import com.xebialabs.license.service.AbstractLicenseService
import com.xebialabs.license.{Clock, License, LicenseReader}

class InMemoryLicenseService(product: String, rms: RepositoryMetadataService, clock: Clock) extends AbstractLicenseService("dummy.lic", product, rms, clock) {
  private[this] val defaultLicense = """--- License ---
                                       |License version: 3
                                       |Product: XL Deploy
                                       |Licensed to: Roadrunner Inc.
                                       |Contact: Jane Doe
                                       |Edition: Enterprise
                                       |--- Signature (SHA1withDSA) ---
                                       |302c021464f4eb3e0df7309b4969e62232e4e4bda8246496021455c08bca73fac2802988a7b9e679
                                       |5d9624e1da6e
                                       |--- End of Signature ---""".stripMargin
  private[this] var testLicense: License = asLicense(defaultLicense)
  license = testLicense
  override protected def readLicense(licenseFile: File): License = testLicense

  def setTestLicense(license: String): Unit = this.testLicense = asLicense(license)
  def setTestLicense(license: License): Unit = this.testLicense = license

  private[this] def asLicense(license: String): License = new LicenseReader().readFromBase64(java.util.Base64.getEncoder.encodeToString(license.getBytes("UTF-8")))
}
