package com.xebialabs.xlplatform.scheduler.ci

import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot._
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlplatform.scheduler.Trigger

import scala.beans.BeanProperty

@Metadata(virtual = true, root = CONFIGURATION, description = "Base scheduled administration job")
abstract class ScheduledJob extends Job {
  @BeanProperty
  @Property(label = "Enabled", defaultValue = "true", description = "Enables or disables triggering of the administration job")
  var enabled: Boolean = true

  /**
   * @return trigger determining when the ScheduledJob should be run
   */
  def getTrigger(): Trigger
}
