package com.xebialabs.xlplatform.security.validator.regex

import com.xebialabs.xlplatform.security.validator.regex.RegexValidator.RegexValidation
import com.xebialabs.xlplatform.security.validator.{StringValidator, Validation}

import scala.util.matching.Regex

object RegexValidator {

  case class RegexValidation(val pattern: Regex, override val message: String) extends Validation[String] {
    override def validate(input: String): Boolean = pattern.findFirstIn(input).nonEmpty
  }

}

class RegexValidator(override val validators: List[RegexValidation]) extends StringValidator
