package com.xebialabs.deployit.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

@SuppressWarnings("serial")
public class ListOfStringView extends AbstractStringView<List<StringValue>> implements List<String> {
    public ListOfStringView() {
        super(new ArrayList<>());
    }

    public ListOfStringView(List<StringValue> wrapped) {
        super(wrapped);
    }

    /**
     * Return an encrypted view of this ListOfStringView.
     * @return an encrypted view
     */
    @Override
    public ListOfStringView encrypt() {
        return new ListOfStringView(wrapped.stream().map(StringValue::encrypt).collect(Collectors.toList()));
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> c) {
        return getWrapped().addAll(index, transformToStringValue(c));
    }

    @Override
    public String get(int index) {
        return getWrapped().get(index).toString();
    }

    @Override
    public String set(int index, String element) {
        return _set(index, new StringValue(element));
    }

    public String setEncrypted(int index, String element) {
        return _set(index, new EncryptedStringValue(element));
    }

    private String _set(int index, StringValue e) {
        StringValue set = getWrapped().set(index, e);
        return set == null ? null : set.toString();
    }

    @Override
    public void add(int index, String element) {
        getWrapped().add(index, new StringValue(element));
    }

    public void addEncrypted(int index, String element) {
        getWrapped().add(index, new EncryptedStringValue(element));
    }

    @Override
    public String remove(int index) {
        return getWrapped().remove(index).toString();
    }

    @Override
    public int indexOf(Object o) {
        return getWrapped().indexOf(stringToStringValue(o));
    }

    @Override
    public int lastIndexOf(Object o) {
        return getWrapped().lastIndexOf(stringToStringValue(o));
    }

    @Override
    public ListIterator<String> listIterator() {
        return new TransformingListIterator(getWrapped().listIterator());
    }

    @Override
    public ListIterator<String> listIterator(int index) {
        return new TransformingListIterator(getWrapped().listIterator(index));
    }

    @Override
    public List<String> subList(int fromIndex, int toIndex) {
        return new ListOfStringView(getWrapped().subList(fromIndex, toIndex));
    }

    public static ListOfStringView from(List<String> strings) {
        if (strings instanceof ListOfStringView) {
            return (ListOfStringView) strings;
        } else {
            ListOfStringView stringView = new ListOfStringView();
            if (strings != null) {
                stringView.addAll(strings);
            }
            return stringView;
        }
    }

    public static ListOfStringView copy(List<String> strings) {
        if (strings instanceof ListOfStringView) {
            return new ListOfStringView(new ArrayList<>(((ListOfStringView) strings).getWrapped()));
        } else {
            return from(strings);
        }
    }

    private static class TransformingListIterator implements ListIterator<String> {
        private ListIterator<StringValue> wrappedIterator;

        private TransformingListIterator(ListIterator<StringValue> wrappedIterator) {
            this.wrappedIterator = wrappedIterator;
        }

        @Override
        public boolean hasNext() {
            return wrappedIterator.hasNext();
        }

        @Override
        public String next() {
            return wrappedIterator.next().toString();
        }

        @Override
        public boolean hasPrevious() {
            return wrappedIterator.hasPrevious();
        }

        @Override
        public String previous() {
            return wrappedIterator.previous().toString();
        }

        @Override
        public int nextIndex() {
            return wrappedIterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return wrappedIterator.previousIndex();
        }

        @Override
        public void remove() {
            wrappedIterator.remove();
        }

        @Override
        public void set(String s) {
            wrappedIterator.set(new StringValue(s));
        }

        @Override
        public void add(String s) {
            wrappedIterator.add(new StringValue(s));
        }
    }
}
