package com.xebialabs.deployit.core;

import java.io.Serializable;

@SuppressWarnings("serial")
public class StringValue implements Serializable {
    protected final String value;

    public StringValue(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        StringValue that = (StringValue) o;

        return !(value != null ? !value.equals(that.value) : that.value != null);
    }

    @Override
    public int hashCode() {
        return value != null ? value.hashCode() : 0;
    }

    public boolean isEncrypted() {
        return false;
    }

    public String toPublicFacingValue() {
        return value;
    }

    public StringValue encrypt() {
        return new EncryptedStringValue(value);
    }
}
