package com.xebialabs.deployit.core;

/**
 * The contents of this class is unencrypted while this class is alive, but on the boundaries of the server-core, the string should be encrypted.
 */
@SuppressWarnings("serial")
public class EncryptedStringValue extends StringValue {

    public EncryptedStringValue(String value) {
        super(value);
    }

    @Override
    public boolean isEncrypted() {
        return true;
    }

    @Override
    public String toPublicFacingValue() {
        return "********";
    }

    @Override
    public StringValue encrypt() {
        return this;
    }

    // TODO implement readObject and writeObject to encrypt the contents.
}
