/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.test.jackrabbit;

import com.typesafe.config.Config;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.util.GuavaFiles;
import com.xebialabs.xlplatform.repository.RepositoryConfigurationSource;
import com.xebialabs.xlplatform.repository.XlJcrRepositoryInitializer;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import com.xebialabs.xlplatform.test.jcr.RepositoryProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class TestJackrabbitRepositoryBooter
implements RepositoryProvider {
    private static final Logger logger = LoggerFactory.getLogger(TestJackrabbitRepositoryBooter.class);
    private RepositoryImpl repository;
    private File homeDir = null;

    @Override
    public Repository boot(XlRepositoryConfig xlRepositoryConfig) throws RepositoryException {
        RepositoryImpl repositoryImpl;
        block10: {
            try {
                this.homeDir = Files.createTempDirectory("jackrabbit", new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                throw new RuntimeIOException((Throwable)e);
            }
            LocalBooter.bootWithoutGlobalContext();
            logger.info("Booting test jackrabbit repository with config {}", (Object)xlRepositoryConfig.repositoryName());
            Config jackrabbitRepositoryConfig = xlRepositoryConfig.repositoryConfig();
            RepositoryConfigurationSource configSource = new RepositoryConfigurationSource(jackrabbitRepositoryConfig.getString("configurationLocation"));
            InputStream stream = configSource.getInputStream();
            try {
                InputSource configurationInputSource = new InputSource(stream);
                RepositoryConfig repositoryConfig = RepositoryConfig.create((InputSource)configurationInputSource, (String)this.homeDir.getAbsolutePath());
                this.repository = RepositoryImpl.create((RepositoryConfig)repositoryConfig);
                new XlJcrRepositoryInitializer(xlRepositoryConfig).init((Repository)this.repository);
                repositoryImpl = this.repository;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeIOException((Throwable)e);
                }
            }
            stream.close();
        }
        return repositoryImpl;
    }

    @Override
    public void shutdown() {
        logger.info("Shutting down jackrabbit repository");
        this.repository.shutdown();
        this.repository = null;
        try {
            GuavaFiles.deleteRecursively((File)this.homeDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RepositoryImpl getRepository() {
        return this.repository;
    }
}

