package com.xebialabs.deployit.test.jackrabbit;

import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.repository.RepositoryConfigurationSource;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import scala.Option;

import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;

public class DefaultConfig implements XlRepositoryConfig {

    @Override
    public RepositoryConfigurationSource jcrRepositoryConfig() {
        return new RepositoryConfigurationSource("jackrabbit/inmemory-repository.xml");
    }

    @Override
    public String repositoryName() {
        return "deployit";
    }

    @Override
    public Version repositoryVersion() {
        return Version.valueOf("deployit", Version.VERSION_0);
    }

    @Override
    public Option<String> repositoryId() {
        return Option.apply(null);
    }

    @Override
    public Option<? extends Credentials> credentials() {
        return Option.apply(new SimpleCredentials("admin", "admin".toCharArray()));
    }
}
