package com.xebialabs.deployit.test.jackrabbit;

import com.google.common.io.Files;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.util.GuavaFiles;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import com.xebialabs.xlplatform.repository.XlRepositoryInitializer;
import com.xebialabs.xlplatform.test.jcr.RepositoryProvider;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class InMemoryRepositoryBooter implements RepositoryProvider {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryRepositoryBooter.class);

    private RepositoryImpl repository;

    private XlRepositoryConfig config;

    private File homeDir = Files.createTempDir();

    public Repository boot(XlRepositoryConfig xlConfig) throws RepositoryException {
        this.config = xlConfig;
        try(InputStream stream = xlConfig.jcrRepositoryConfig().getInputStream()) {
            InputSource configurationInputSource = new InputSource(stream);
            RepositoryConfig repositoryConfig = RepositoryConfig.create(configurationInputSource, homeDir.getAbsolutePath());
            repository = RepositoryImpl.create(repositoryConfig);

            new XlRepositoryInitializer(repository, config).init();
            return repository;
        } catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public void shutdown() {
        repository.shutdown();
        try {
            GuavaFiles.deleteRecursively(homeDir);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RepositoryImpl getRepository() {
        return repository;
    }
}
