package com.xebialabs.xlplatform.test.jcr

import com.xebialabs.deployit.booter.local.LocalBooter
import com.xebialabs.deployit.jcr.JcrTemplate
import com.xebialabs.deployit.repository.JcrRepositoryService
import org.scalatest.{BeforeAndAfterAll, BeforeAndAfterEach, Suite}

trait JcrSupport extends BeforeAndAfterAll with BeforeAndAfterEach { self: Suite =>
  val jcrHelper = new JcrTestHelper()
  
  var jcrRepositoryService: JcrRepositoryService = _
  var jcrTemplate: JcrTemplate = _

  override protected def beforeAll(): Unit = {
    super.beforeAll()
    LocalBooter.bootWithoutGlobalContext()
    jcrHelper.setupRepository(new TestRepositoryBooter, new TestRepositoryConfig)
    jcrTemplate = jcrHelper.getJcrTemplate
    jcrRepositoryService = jcrHelper.getRepositoryService
  }

  override protected def afterAll(): Unit = {
    jcrHelper.shutdownRepository()
    super.afterAll()
  }

  override protected def beforeEach(): Unit = {
    jcrTemplate.login()
  }

  override protected def afterEach(): Unit = {
    jcrTemplate.logout()
  }
}
