package com.xebialabs.xlplatform.test.jcr;

import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.util.PasswordEncrypter;

import javax.jcr.RepositoryException;

public abstract class JcrTestBase {

    protected static JcrTestHelper jcrTestHelper;

    protected static JcrTemplate jcrTemplate;
    protected static PasswordEncrypter passwordEncrypter;


    @org.junit.BeforeClass
    @org.testng.annotations.BeforeClass
    public static void setupJcrRepository() throws Exception, RepositoryException {
        LocalBooter.bootWithoutGlobalContext();
        jcrTestHelper = new JcrTestHelper();
        jcrTestHelper.setupRepository(new TestRepositoryBooter(), new TestRepositoryConfig());
        jcrTemplate = jcrTestHelper.getJcrTemplate();
        passwordEncrypter = PasswordEncrypter.getInstance();
    }

    @org.junit.AfterClass
    @org.testng.annotations.AfterClass
    public static void shutdownJcrRepository() {
        jcrTestHelper.shutdownRepository();
    }
}
