package com.xebialabs.xlplatform.test.jcr;

import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.JcrRepositoryService;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import com.xebialabs.xlplatform.test.ci.NoLicenseService;
import org.modeshape.jcr.api.JcrTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import java.io.IOException;

/**
 */
public class JcrTestHelper {
    private static final Logger logger = LoggerFactory.getLogger(JcrTestHelper.class);

    private JcrTemplate jcrTemplate;
    private RepositoryProvider booter;
    private PasswordEncrypter passwordEncrypter;

    public void setupRepository(RepositoryProvider provider, XlRepositoryConfig config) throws RepositoryException, IOException {
        this.booter = provider;
        passwordEncrypter = new RandomPasswordEncrypterProvider().randomPassword();
        Repository repo = booter.boot(config);
        jcrTemplate = new JcrTemplate(repo, config.credentials().get());
        // Set the template in the holder
        new JcrTemplateHolder(jcrTemplate);
    }

    public void shutdownRepository() {
        booter.shutdown();
    }

    public Repository getRepository() {
        return booter.getRepository();
    }

    public JcrRepositoryService getRepositoryService() {
        return new JcrRepositoryService(jcrTemplate, passwordEncrypter, new NoLicenseService());
    }

    public JcrTemplate getJcrTemplate() {
        return jcrTemplate;
    }

    public void cleanupRepository() {
        jcrTemplate.execute(new JcrCallback<Void>() {
            @Override
            public Void doInJcr(Session session) throws RepositoryException {
                JcrTools jcrTools = new JcrTools();
                for (Metadata.ConfigurationItemRoot root : Metadata.ConfigurationItemRoot.values()) {
                    if (root != Metadata.ConfigurationItemRoot.NESTED) {
                        int removed = jcrTools.removeAllChildren(session, JcrPathHelper.getAbsolutePathFromId(root.getRootNodeName()));
                        logger.info("Removed {} children from {}", removed, root);
                    }
                }
                session.save();
                return null;
            }
        });
    }
}
