package com.xebialabs.xlplatform.test.jcr;

import com.xebialabs.xlplatform.repository.RepositoryConfigurationSource;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import com.xebialabs.xlplatform.repository.XlRepositoryInitializer;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.collection.Problems;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.RepositoryConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class TestRepositoryBooter implements RepositoryProvider {
    private static final Logger logger = LoggerFactory.getLogger(TestRepositoryBooter.class);

    private JcrRepository repository;

    private ModeShapeEngine engine;
    private XlRepositoryConfig config;

    public Repository boot(XlRepositoryConfig config) throws RepositoryException {
        this.config = config;
        engine = new ModeShapeEngine();
        engine.start();
        RepositoryConfiguration modeShapeConfig = readConfig(config.jcrRepositoryConfig());
        repository = engine.deploy(modeShapeConfig);
        new XlRepositoryInitializer(repository, config).init();
        return repository;
    }

    private RepositoryConfiguration readConfig(RepositoryConfigurationSource source) throws RepositoryException {
        try(InputStream is = source.getInputStream()) {
            RepositoryConfiguration config = RepositoryConfiguration.read(is, source.getName());
            Problems problems = config.validate();
            if (!problems.isEmpty()) {
                for (Problem problem : problems) {
                    logger.error(problem.getMessageString());
                }
                throw new RepositoryException("Could not boot due to problems");
            }
            return config;
        } catch (RepositoryException re) {
            throw re;
        } catch (Exception e) {
            throw new RepositoryException(e);
        }
    }

    public void shutdown() {
        Future<Boolean> shutdown = engine.shutdown();
        try {
            if (!shutdown.get()) {
                throw new IllegalStateException("Did not shutdown...");
            }
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Failed to shutdown", e);
        } catch (ExecutionException e) {
            throw new IllegalStateException("Failed to shutdown", e);
        }
    }

    public JcrRepository getRepository() {
        return repository;
    }
}
