package com.xebialabs.xlplatform.test.workdir

import com.xebialabs.deployit.repository.WorkDir
import com.xebialabs.overthere.local.LocalFile
import com.xebialabs.xlplatform.sugar.TempDirectorySugar

trait WorkDirSugar extends TempDirectorySugar {

  type WithWorkDir[T] = WorkDir => T

  def withWorkDir[T](f: WithWorkDir[T]): T = {
    val dir: WorkDir = new WorkDir(LocalFile.valueOf(createTempDirectory().fileOption.get).asInstanceOf[LocalFile])
    try {
      f(dir)
    } finally {
      dir.delete()
    }
  }
}
