/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.test.jcr;

import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.JcrRepositoryService;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import com.xebialabs.xlplatform.test.ci.NoLicenseService;
import com.xebialabs.xlplatform.test.jcr.RandomPasswordEncrypterProvider;
import com.xebialabs.xlplatform.test.jcr.RepositoryProvider;
import java.io.IOException;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.modeshape.jcr.api.JcrTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrTestHelper {
    private static final Logger logger = LoggerFactory.getLogger(JcrTestHelper.class);
    private JcrTemplate jcrTemplate;
    private RepositoryProvider booter;
    private PasswordEncrypter passwordEncrypter;

    public void setupRepository(RepositoryProvider provider, XlRepositoryConfig config) throws RepositoryException, IOException {
        this.booter = provider;
        this.passwordEncrypter = new RandomPasswordEncrypterProvider().randomPassword();
        Repository repo = this.booter.boot(config);
        this.jcrTemplate = new JcrTemplate(repo, (Credentials)config.credentials().get());
        new JcrTemplateHolder(this.jcrTemplate);
    }

    public void shutdownRepository() {
        this.booter.shutdown();
    }

    public Repository getRepository() {
        return this.booter.getRepository();
    }

    public JcrRepositoryService getRepositoryService() {
        return new JcrRepositoryService(this.jcrTemplate, this.passwordEncrypter, (LicenseService)new NoLicenseService());
    }

    public JcrTemplate getJcrTemplate() {
        return this.jcrTemplate;
    }

    public void cleanupRepository() {
        this.jcrTemplate.execute((JcrCallback)new JcrCallback<Void>(){

            public Void doInJcr(Session session) throws RepositoryException {
                JcrTools jcrTools = new JcrTools();
                for (Metadata.ConfigurationItemRoot root : Metadata.ConfigurationItemRoot.values()) {
                    if (root == Metadata.ConfigurationItemRoot.NESTED) continue;
                    int removed = jcrTools.removeAllChildren(session, JcrPathHelper.getAbsolutePathFromId((String)root.getRootNodeName()));
                    logger.info("Removed {} children from {}", (Object)removed, (Object)root);
                }
                session.save();
                return null;
            }
        });
    }
}

