/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.test.modeshape;

import com.xebialabs.xlplatform.repository.RepositoryConfigurationSource;
import com.xebialabs.xlplatform.repository.XlJcrRepositoryInitializer;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import com.xebialabs.xlplatform.test.jcr.RepositoryProvider;
import java.io.InputStream;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.collection.Problems;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.RepositoryConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestModeshapeRepositoryBooter
implements RepositoryProvider {
    private static final Logger logger = LoggerFactory.getLogger(TestModeshapeRepositoryBooter.class);
    private JcrRepository repository;
    private ModeShapeEngine engine;

    @Override
    public Repository boot(XlRepositoryConfig config) throws RepositoryException {
        logger.info("Booting test modeshape repository with config {}", (Object)config.repositoryName());
        this.engine = new ModeShapeEngine();
        this.engine.start();
        String configLocation = config.repositoryConfig().getString("configurationLocation");
        RepositoryConfiguration modeShapeConfig = this.readConfig(new RepositoryConfigurationSource(configLocation));
        this.repository = this.engine.deploy(modeShapeConfig);
        new XlJcrRepositoryInitializer(config).init((Repository)this.repository);
        logger.debug("Successfully initialized the repository");
        return this.repository;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RepositoryConfiguration readConfig(RepositoryConfigurationSource source) throws RepositoryException {
        try (InputStream is = source.getInputStream();){
            RepositoryConfiguration config = RepositoryConfiguration.read((InputStream)is, (String)source.getName());
            Problems problems = config.validate();
            if (!problems.isEmpty()) {
                Iterator iterator = problems.iterator();
                while (iterator.hasNext()) {
                    Problem problem = (Problem)iterator.next();
                    logger.error(problem.getMessageString());
                }
                throw new RepositoryException("Could not boot due to problems");
            }
            RepositoryConfiguration repositoryConfiguration = config;
            return repositoryConfiguration;
        }
        catch (RepositoryException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        logger.info("Shutting down modeshape repository");
        Future shutdown = this.engine.shutdown();
        this.repository = null;
        this.engine = null;
        try {
            if (!((Boolean)shutdown.get()).booleanValue()) {
                throw new IllegalStateException("Did not shutdown...");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Failed to shutdown", e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Failed to shutdown", e);
        }
    }

    public JcrRepository getRepository() {
        return this.repository;
    }
}

