/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.test.jcr;

import com.xebialabs.deployit.JcrCredentials;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.JcrRepositoryService;
import com.xebialabs.deployit.repository.RepositoryMetadataService;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlplatform.repository.JcrRepositoryMetadataService;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import com.xebialabs.xlplatform.test.RandomPasswordEncrypterProvider;
import com.xebialabs.xlplatform.test.ci.NoLicenseService;
import com.xebialabs.xlplatform.test.jcr.JcrTools;
import com.xebialabs.xlplatform.test.jcr.RepositoryProvider;
import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrTestHelper {
    private static final Logger logger = LoggerFactory.getLogger(JcrTestHelper.class);
    private JcrTemplate jcrTemplate;
    private RepositoryProvider booter;
    private PasswordEncrypter passwordEncrypter;
    private RepositoryMetadataService repositoryMetadataService;

    public JcrTestHelper() {
    }

    public JcrTestHelper(RepositoryProvider provider, XlRepositoryConfig config) throws IOException, RepositoryException {
        this.setupRepository(provider, config);
    }

    public void setupRepository(RepositoryProvider provider, XlRepositoryConfig config) throws RepositoryException, IOException {
        this.booter = provider;
        this.passwordEncrypter = new RandomPasswordEncrypterProvider().randomPassword();
        Repository repo = this.booter.boot(config);
        this.jcrTemplate = new JcrTemplate(repo, ((JcrCredentials)config.credentials()).creds());
        this.repositoryMetadataService = new JcrRepositoryMetadataService(this.jcrTemplate);
        new JcrTemplateHolder(this.jcrTemplate);
    }

    public void shutdownRepository() {
        this.booter.shutdown();
    }

    public Repository getRepository() {
        return this.booter.getRepository();
    }

    public JcrRepositoryService getRepositoryService() {
        return this.getRepositoryService(new NoLicenseService());
    }

    public JcrRepositoryService getRepositoryService(LicenseService licenseService) {
        JcrRepositoryService jcrRepositoryService = new JcrRepositoryService(this.jcrTemplate, this.passwordEncrypter, licenseService);
        jcrRepositoryService.initializeLicenseValidator();
        return jcrRepositoryService;
    }

    public JcrTemplate getJcrTemplate() {
        return this.jcrTemplate;
    }

    public RepositoryMetadataService getRepositoryMetadataService() {
        return this.repositoryMetadataService;
    }

    public void cleanupRepository() {
        this.jcrTemplate.execute((JcrCallback)new JcrCallback<Void>(){

            public Void doInJcr(Session session) throws RepositoryException {
                JcrTools jcrTools = new JcrTools();
                for (Metadata.ConfigurationItemRoot root : Metadata.ConfigurationItemRoot.values()) {
                    if (root == Metadata.ConfigurationItemRoot.NESTED) continue;
                    int removed = jcrTools.removeAllChildren(session, JcrPathHelper.getAbsolutePathFromId((String)root.getRootNodeName()));
                    logger.info("Removed {} children from {}", (Object)removed, (Object)root);
                }
                JcrTestHelper.this.clearRepositoryId(session);
                session.save();
                return null;
            }
        });
    }

    private void clearRepositoryId(Session session) throws RepositoryException {
        Node node = session.getNode("/$configuration");
        if (node.hasProperty("repositoryid")) {
            node.getProperty("repositoryid").remove();
        }
        this.repositoryMetadataService = new JcrRepositoryMetadataService(this.jcrTemplate);
    }
}

