package com.xebialabs.xlplatform.test.jackrabbit;

import javax.jcr.SimpleCredentials;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValueFactory;

import com.xebialabs.deployit.JcrCredentials;
import com.xebialabs.deployit.RepoCredentials;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;

import static com.xebialabs.deployit.jcr.JcrConstants.ADMIN_PASSWORD;
import static com.xebialabs.deployit.jcr.JcrConstants.ADMIN_USERNAME;

public class TestJackrabbitRepositoryConfig implements XlRepositoryConfig {

    @Override
    public Config repositoryConfig() {
        return ConfigFactory.empty().withValue("configurationLocation",
                ConfigValueFactory.fromAnyRef("jackrabbit/inmemory-repository.xml"));
    }

    @Override
    public RepoCredentials credentials() {
        return JcrCredentials.apply(new SimpleCredentials(ADMIN_USERNAME, ADMIN_PASSWORD.toCharArray()));
    }

    @Override
    public String repositoryName() {
        return "deployit";
    }

    @Override
    public Version repositoryVersion() {
        return Version.valueOf("deployit", Version.VERSION_0);
    }

    @Override
    public String repositoryId() {
        return null;
    }

}
