package com.xebialabs.xlplatform.ui

import scala.xml.{NodeSeq, Text, Elem}
import spray.httpx.marshalling.Marshaller
import spray.http.MediaTypes._


trait MenuXmlProtocol {

  implicit def optStringToOptText(opt: Option[String]) = opt.map(Text(_))

  def menuItemToXml(m: MenuItem): Elem = <menu-item label={m.label} uri={m.uri} weight={m.weight.toString}/>

  def menuSeparatorToXml(m: MenuSeparator): Elem = <menu-separator weight={m.weight.toString}/>

  val menuToXml: (Menu) => NodeSeq = (m: Menu) => <menu id={m.id} label={m.label} uri={m.uri} weight={m.weight.toString}>{
    m.items.map {
      case menu: Menu => menuToXml(menu)
      case menuItem: MenuItem => menuItemToXml(menuItem)
      case menuSeparator: MenuSeparator => menuSeparatorToXml(menuSeparator)
    }
    }</menu>

  implicit val XmlMenuMarshaller = Marshaller.delegate[Menu, NodeSeq](`text/xml`, `application/xml`)(menuToXml)

  implicit val XmlMenuListMarshaller = Marshaller.delegate[scala.collection.immutable.List[Menu], NodeSeq](`text/xml`, `application/xml`)(hs =>
    <list>
      { for (h <- hs) yield menuToXml(h) }
    </list>

  )
}
