package com.xebialabs.xlplatform.ui

import akka.actor.ActorSystem
import akka.util.Timeout
import com.xebialabs.xlplatform.endpoints.{AuthenticatedData, ExtensionRoutes}
import grizzled.slf4j.Logging
import spray.http.{HttpResponse, StatusCodes}
import spray.httpx.SprayJsonSupport

import scala.concurrent.Future
import scala.concurrent.duration._
import scala.language.postfixOps
import scala.util.{Failure, Success}

class MetadataExtensionRoute extends ExtensionRoutes with SprayJsonSupport with MenuXmlProtocol with MenuJsonProtocol with Logging {
  private implicit val timeout = Timeout(2 seconds)

  def route(system: ActorSystem) = (auth: AuthenticatedData) => {
    implicit val ec = system.dispatcher
    pathPrefix("metadata") {
      (get|post) {
        onComplete(Future { UiMenus(Settings.XlDeploy.UiExtension.file(system.settings.config)) }) {
          case Success(menus) =>
            logger.info(s"Found UI extensions: $menus")
            complete(menus.asInstanceOf[List[Menu]])
          case Failure(e: Throwable ) =>
            logger.error(s"UI extensions could not be loaded", e)
            complete(HttpResponse(StatusCodes.InternalServerError, e.getMessage))
        }
      }
    }
  }
}