package com.xebialabs.xlplatform.webhooks.domain

import java.util.Date

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlplatform.webhooks.events.domain.EventSource.CiEventSource
import com.xebialabs.xlplatform.webhooks.events.domain.{Event, EventSource}

import scala.beans.BeanProperty
import scala.collection.JavaConverters._

@Metadata(virtual = false, label = "Http Request Event")
class HttpRequestEvent extends Event {

  @BeanProperty
  @Property(label = "Source endpoint", required = true)
  var source: CiEventSource = _

  @BeanProperty
  @Property(label = "Request Headers")
  var headers: java.util.Map[String, String] = _

  @BeanProperty
  @Property(label = "Request Parameters")
  var parameters: java.util.Map[String, String] = _

  @BeanProperty
  @Property(label = "Request Body")
  var content: String = _

}

object HttpRequestEvent {
  def apply(source: EventSource,
            headers: java.util.Map[String, String],
            parameters: java.util.Map[String, Array[String]],
            content: String): HttpRequestEvent = {
    val event = new HttpRequestEvent
    event.sourceId = source.sourceId
    event.received = new Date()
    event.headers = headers
    event.parameters = parameters.asScala.mapValues(_.mkString(", ")).asJava
    event.content = content
    event
  }

}