package com.xebialabs.xlplatform.webhooks.domain

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.xlplatform.webhooks.events.domain.EventSource

import scala.beans.BeanProperty

trait Endpoint extends EventSource {
  self: BaseConfigurationItem =>

  type RequestAuthenticationType <: BaseConfigurationItem with RequestAuthentication

  override def outputType: Type = Type.valueOf(classOf[HttpRequestEvent])

  @BeanProperty
  @Property(label = "Path for this endpoint", required = true)
  var path: String = _

  @BeanProperty
  @Property(label = "HTTP Method", defaultValue = "POST")
  var method: EndpointHttpMethod = _

  @BeanProperty
  @Property(label = "Authentication Method", required = true)
  var authentication: RequestAuthenticationType = _

}
