package com.xebialabs.xlplatform.webhooks.events.domain

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.Property
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.xlplatform.webhooks.annotations.TypeBounds

import scala.beans.BeanProperty

trait EventSource {
  self: BaseConfigurationItem =>

  def sourceId: EventSource.ID = self.getId

  def outputType: Type = Option(outputEventType).map(Type.valueOf).orNull

  @TypeBounds(focusType = "events.Event", topType = "events.Event", canBeVirtual = true)
  @BeanProperty
  @Property(label = "Output Event Type", description = "Type of the output event")
  var outputEventType: String = _

  @BeanProperty
  @Property(label = "Enabled", description = "Enable this event source")
  var sourceEnabled: Boolean = true

}

object EventSource {
  type ID = String

  type CiEventSource = BaseConfigurationItem with EventSource

}