/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.jenkins;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import com.xebialabs.overthere.spi.OverthereConnectionBuilder;
import com.xebialabs.overthere.spi.Protocol;
import com.xebialabs.xltest.jenkins.JenkinsFile;
import com.xebialabs.xltest.jenkins.JenkinsQueueInspector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.resteasy.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Protocol(name="jenkins")
public class JenkinsConnection
extends BaseOverthereConnection
implements OverthereConnectionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(JenkinsConnection.class);
    public static final String JENKINS_PROTOCOL = "jenkins";
    public static final String JOB_NAME = "jobName";
    public static final String UNIQUE_ID_PARAMETER_NAME = "uniqueIdParameterName";
    public static final String JOB_PARAMETERS = "jobParameters";
    private final String address;
    private final String username;
    private final String password;
    private final String jobName;
    private final Map<String, String> jobParameters;
    private final String uniqueIdParameterName;
    private int timeout = 3600000;
    private File localWorkspaceDirectory;

    public JenkinsConnection(String protocol, ConnectionOptions options, AddressPortMapper mapper) {
        super(protocol, options, mapper, true);
        String addr = (String)options.get("address");
        Integer port = (Integer)options.get("port");
        String portAsString = port == null ? "" : ":" + port.toString();
        this.address = addr.endsWith("/") ? addr.substring(0, addr.length() - 1) + portAsString + "/" : addr + portAsString + "/";
        this.username = (String)options.getOptional("username");
        this.password = (String)options.getOptional("password");
        this.jobName = (String)options.get(JOB_NAME);
        this.jobParameters = (Map)options.get(JOB_PARAMETERS);
        this.uniqueIdParameterName = (String)options.get(UNIQUE_ID_PARAMETER_NAME, (Object)UNIQUE_ID_PARAMETER_NAME);
    }

    public OverthereFile getFile(String hostPath) {
        LOG.info("Looking for path: {}", (Object)hostPath);
        return new JenkinsFile(this, hostPath);
    }

    public OverthereFile getFile(OverthereFile parent, String child) {
        LOG.info("Looking for path: {}/{}", (Object)parent, (Object)child);
        return new JenkinsFile(this, (JenkinsFile)parent, child);
    }

    public OverthereProcess startProcess(CmdLine commandLine) {
        JenkinsQueueInspector jenkinsQueueInspector;
        String uniqueId = UUID.randomUUID().toString();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(this.uniqueIdParameterName, uniqueId);
        if (this.jobParameters != null) {
            parameters.putAll(this.jobParameters);
        }
        int responseCode = this.buildJob(parameters);
        try {
            jenkinsQueueInspector = new JenkinsQueueInspector(new URL("http://" + this.address), this.jobName, this.username, this.password, this.uniqueIdParameterName, uniqueId);
        }
        catch (MalformedURLException e) {
            throw new RuntimeIOException("Unable to inspect Jenkins queue", (Throwable)e);
        }
        return new OverthereProcess(){
            boolean hasExited = false;
            public int exitCode;

            public OutputStream getStdin() {
                return new ByteArrayOutputStream();
            }

            public InputStream getStdout() {
                return new ByteArrayInputStream(new byte[0]);
            }

            public InputStream getStderr() {
                return new ByteArrayInputStream(new byte[0]);
            }

            public int waitFor() throws InterruptedException {
                if (!this.hasExited) {
                    try {
                        this.exitCode = jenkinsQueueInspector.waitForJobToFinish(JenkinsConnection.this.timeout);
                    }
                    catch (Exception e) {
                        throw new RuntimeIOException("Error while waiting for job " + JenkinsConnection.this.jobName + " to finish", (Throwable)e);
                    }
                    finally {
                        this.hasExited = true;
                    }
                }
                return this.exitCode;
            }

            public void destroy() {
                if (!this.hasExited) {
                    try {
                        jenkinsQueueInspector.stopBuild();
                    }
                    catch (Exception e) {
                        throw new RuntimeIOException("Unable to force-stop job " + JenkinsConnection.this.jobName, (Throwable)e);
                    }
                    finally {
                        this.hasExited = true;
                    }
                }
            }

            public int exitValue() throws IllegalThreadStateException {
                if (!this.hasExited) {
                    throw new IllegalThreadStateException("process hasn't exited");
                }
                return this.exitCode;
            }
        };
    }

    public OverthereConnection connect() {
        return this;
    }

    protected void doClose() {
    }

    public OverthereFile getFileForTempFile(OverthereFile parent, String name) {
        throw new UnsupportedOperationException("Cannot deal with temp files on " + (Object)((Object)this));
    }

    public String toString() {
        return "jenkins:" + this.username + "@" + this.address + "job/" + this.jobName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File downloadJenkinsWorkspace(String hostPath) {
        if (this.localWorkspaceDirectory != null) {
            return this.localWorkspaceDirectory;
        }
        HttpURLConnection conn = null;
        try {
            File saveDir = this.newLocalWorkspaceDirectory(hostPath);
            String fileName = "xltest-download.zip";
            URL zipUrl = new URL(new URL("http://" + this.address), String.format("job/%s/ws/%s/*zip*/%s", this.jobName, hostPath, "xltest-download.zip"));
            conn = (HttpURLConnection)zipUrl.openConnection();
            this.addHeaders(conn);
            int responseCode = conn.getResponseCode();
            switch (responseCode) {
                case 200: {
                    try (InputStream inputStream = conn.getInputStream();){
                        this.extract(saveDir, inputStream);
                    }
                    LOG.debug("Done, unzipped in dir: " + this.localWorkspaceDirectory.getPath());
                    break;
                }
                case 401: {
                    if (this.username != null) {
                        throw new RuntimeIOException(String.format("Can not log on to Jenkins with user %s", this.username));
                    }
                    throw new RuntimeIOException(String.format("Authorization is required for Jenkins at %s", this.address));
                }
                case 403: {
                    throw new RuntimeIOException(String.format("Not allowed to access workspace folder '%s'", hostPath));
                }
                case 404: {
                    throw new RuntimeIOException(String.format("The folder '%s' could not be found in the workspace for job %s", hostPath, this.jobName));
                }
                default: {
                    throw new RuntimeIOException(String.format("Unable to download workspace folder '%s'(status code = %d)", hostPath, responseCode));
                }
            }
            File file = this.localWorkspaceDirectory;
            return file;
        }
        catch (IOException e) {
            this.localWorkspaceDirectory = null;
            throw new RuntimeIOException(String.format("Can not connect to Jenkins on URL %s (invalid url?)", this.address), (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private File newLocalWorkspaceDirectory(String hostPath) {
        File saveDir;
        this.localWorkspaceDirectory = Files.createTempDir();
        String parent = new File(hostPath).getParent();
        if (parent != null) {
            saveDir = new File(this.localWorkspaceDirectory, parent);
        } else {
            saveDir = this.localWorkspaceDirectory;
            if ("".equals(hostPath) || "/".equals(hostPath) || ".".equals(hostPath)) {
                this.localWorkspaceDirectory = new File(this.localWorkspaceDirectory, "workspace");
            }
        }
        return saveDir;
    }

    private HttpURLConnection addHeaders(HttpURLConnection conn) {
        conn.setInstanceFollowRedirects(true);
        if (!Strings.isNullOrEmpty((String)this.username)) {
            String userPassword = this.username + ":" + (this.password != null ? this.password : "");
            String encoding = new String(Base64.encodeBytes((byte[])userPassword.getBytes()));
            conn.setRequestProperty("Authorization", "Basic " + encoding);
        }
        return conn;
    }

    protected void extract(File baseDir, InputStream is) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(is);
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            File file = new File(baseDir, entry.getName());
            LOG.debug("Copying {} into file {}", (Object)entry.getName(), (Object)file);
            Files.createParentDirs((File)file);
            Files.write((byte[])ByteStreams.toByteArray((InputStream)zis), (File)file);
        }
    }

    public int buildJob(Map<String, Object> parameters) {
        HttpURLConnection conn = null;
        try {
            URL buildURL = new URL(new URL("http://" + this.address), String.format("job/%s/buildWithParameters?%s", this.jobName, this.makeContent(parameters)));
            LOG.info("Kicking off a job on Jenkins using this URL: " + buildURL.toString());
            conn = (HttpURLConnection)buildURL.openConnection();
            conn.setInstanceFollowRedirects(false);
            this.addHeaders(conn);
            int responseCode = conn.getResponseCode();
            LOG.info("Kicking off a job on Jenkins resulted in http responseCode: " + responseCode);
            int n = responseCode;
            return n;
        }
        catch (MalformedURLException e) {
            throw new RuntimeIOException("Invalid URL", (Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Unable to start job", (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private String makeContent(Map<String, Object> parameters) {
        StringBuilder sb = new StringBuilder();
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                sb.append(key);
                sb.append('=');
                sb.append(parameters.get(key));
                sb.append('&');
            }
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    public File getAbsoluteFileInLocalWorkspaceDirectory(String path) {
        return new File(this.downloadJenkinsWorkspace(path), path);
    }
}

