/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.directory;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.store.IndexInput;

public class IndexInputStream
extends InputStream {
    private final IndexInput in;
    private final long len;
    private long pos;

    public IndexInputStream(IndexInput input) {
        this.in = input;
        this.len = input.length();
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        if (this.read(buf, 0, 1) == -1) {
            return -1;
        }
        return buf[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.pos >= this.len) {
            return -1;
        }
        int num = (int)Math.min((long)(len - off), this.len - this.pos);
        this.in.readBytes(b, off, num);
        this.pos += (long)num;
        return num;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

