/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.xstream;

import com.google.common.collect.Lists;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.CiReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CiXstreamReader
implements CiReader,
CiListReader {
    private final HierarchicalStreamReader reader;

    public CiXstreamReader(HierarchicalStreamReader reader) {
        this.reader = reader;
    }

    @Override
    public String getType() {
        return this.reader.getNodeName();
    }

    @Override
    public String getId() {
        return this.reader.getAttribute("id");
    }

    @Override
    public String getToken() {
        return this.reader.getAttribute("token");
    }

    @Override
    public boolean hasMoreProperties() {
        return this.reader.hasMoreChildren();
    }

    @Override
    public void moveIntoProperty() {
        this.reader.moveDown();
    }

    @Override
    public CiReader moveIntoNestedProperty() {
        this.reader.moveDown();
        return this;
    }

    @Override
    public void moveOutOfProperty() {
        this.reader.moveUp();
    }

    @Override
    public String getCurrentPropertyName() {
        return this.reader.getNodeName();
    }

    @Override
    public String getStringValue() {
        return this.reader.getValue();
    }

    @Override
    public List<String> getStringValues() {
        ArrayList<String> strings = new ArrayList<String>();
        while (this.reader.hasMoreChildren()) {
            this.reader.moveDown();
            strings.add(this.reader.getValue());
            this.reader.moveUp();
        }
        return strings;
    }

    @Override
    public Map<String, String> getStringMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        while (this.reader.hasMoreChildren()) {
            this.reader.moveDown();
            map.put(this.reader.getAttribute("key"), this.reader.getValue());
            this.reader.moveUp();
        }
        return map;
    }

    @Override
    public boolean isCiReference() {
        return this.reader.getAttribute("ref") != null;
    }

    @Override
    public String getCiReference() {
        return this.reader.getAttribute("ref");
    }

    @Override
    public List<String> getCiReferences() {
        ArrayList<String> references = new ArrayList<String>();
        while (this.reader.hasMoreChildren()) {
            this.reader.moveDown();
            references.add(this.getCiReference());
            this.reader.moveUp();
        }
        return references;
    }

    @Override
    public CiListReader getCurrentCiListReader() {
        return this;
    }

    @Override
    public List<ValidationMessage> getValidationMessages() {
        ArrayList messages = Lists.newArrayList();
        while (this.reader.hasMoreChildren()) {
            this.reader.moveDown();
            messages.add(new ValidationMessage(this.reader.getAttribute("ci"), this.reader.getAttribute("property"), this.getStringValue()));
            this.reader.moveUp();
        }
        return messages;
    }

    @Override
    public boolean hasMoreChildren() {
        return this.reader.hasMoreChildren();
    }

    @Override
    public void moveIntoChild() {
        this.reader.moveDown();
    }

    @Override
    public void moveOutOfChild() {
        this.reader.moveUp();
    }

    @Override
    public CiReader getCurrentCiReader() {
        return this;
    }
}

