/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.config.support.ContextPropagatingCallable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context
implements ReadOnlyContext {
    private static final Map<String, Context> CONTEXT_MAP = Collections.synchronizedMap(new HashMap());
    private static ThreadLocal<String> CORRELATION_ID = new ThreadLocal();
    private WroConfiguration config;
    private transient HttpServletRequest request;
    private transient HttpServletResponse response;
    private transient ServletContext servletContext;
    private transient FilterConfig filterConfig;
    private String aggregatedFolderPath;

    @Override
    public WroConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(WroConfiguration config) {
        this.config = config;
    }

    public static Context webContext(HttpServletRequest request, HttpServletResponse response, FilterConfig filterConfig) {
        return new Context(request, response, filterConfig);
    }

    public static Context standaloneContext() {
        return new Context();
    }

    public static Context get() {
        Context.validateContext();
        String correlationId = CORRELATION_ID.get();
        return CONTEXT_MAP.get(correlationId);
    }

    public static boolean isContextSet() {
        return CORRELATION_ID.get() != null && CONTEXT_MAP.get(CORRELATION_ID.get()) != null;
    }

    private static void validateContext() {
        if (!Context.isContextSet()) {
            throw new WroRuntimeException("No context associated with CURRENT request cycle!");
        }
    }

    public static void set(Context context) {
        Context.set(context, new WroConfiguration());
    }

    public static void set(Context context, WroConfiguration config) {
        Validate.notNull((Object)context);
        Validate.notNull((Object)config);
        context.setConfig(config);
        String correlationId = Context.generateCorrelationId();
        CORRELATION_ID.set(correlationId);
        CONTEXT_MAP.put(correlationId, context);
    }

    private static String generateCorrelationId() {
        return UUID.randomUUID().toString();
    }

    public static void unset() {
        String correlationId = CORRELATION_ID.get();
        if (correlationId != null) {
            CONTEXT_MAP.remove(correlationId);
        }
        CORRELATION_ID.remove();
    }

    private Context() {
    }

    private Context(HttpServletRequest request, HttpServletResponse response, FilterConfig filterConfig) {
        this.request = request;
        this.response = response;
        this.servletContext = filterConfig != null ? filterConfig.getServletContext() : null;
        this.filterConfig = filterConfig;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    @Override
    public String getAggregatedFolderPath() {
        return this.aggregatedFolderPath;
    }

    public void setAggregatedFolderPath(String aggregatedFolderPath) {
        this.aggregatedFolderPath = aggregatedFolderPath;
    }

    public static void destroy() {
        Context.unset();
        CONTEXT_MAP.clear();
    }

    public static void setCorrelationId(String correlationId) {
        Validate.notNull((Object)correlationId);
        CORRELATION_ID.set(correlationId);
    }

    public static void unsetCorrelationId() {
        CORRELATION_ID.remove();
    }

    public static String getCorrelationId() {
        Context.validateContext();
        return CORRELATION_ID.get();
    }

    public static <T> Callable<T> decorate(Callable<T> callable) {
        return new ContextPropagatingCallable<T>(callable);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

