/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.utils;

import com.xebialabs.xltest.utils.JsonResponseParser;
import com.xebialabs.xltest.utils.ResponseParser;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonOverHttpHelper {
    private static final Logger LOG = LoggerFactory.getLogger((String)JsonOverHttpHelper.class.getName());
    private HttpClient httpClient = new DefaultHttpClient();
    private final HttpContext localContext;
    private ResponseParser responseParser;
    private String contentType;
    private HttpResponse response;
    private String content;

    public JsonOverHttpHelper() {
        this.httpClient.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        this.localContext = new BasicHttpContext();
        this.expectOutput("json");
    }

    public void expectOutput(String format) {
        if ("json".equalsIgnoreCase(format)) {
            this.responseParser = new JsonResponseParser();
        }
    }

    public void httpGetRequest(String url) throws Exception {
        LOG.info("doing a get on: " + url);
        HttpGet request = new HttpGet(url);
        this.addDefaultHeaders((HttpMessage)request);
        this.executeRequest((HttpUriRequest)request);
    }

    public void httpDeleteRequest(String url) throws Exception {
        LOG.info("doing a delete on: " + url);
        HttpDelete request = new HttpDelete(url);
        this.addDefaultHeaders((HttpMessage)request);
        this.executeRequest((HttpUriRequest)request);
    }

    private void addDefaultHeaders(HttpMessage httpMessage) {
        httpMessage.setHeader("Accept", this.responseParser.acceptedMimeType());
    }

    public void httpPostRequest(String url, String content) throws Exception {
        LOG.info("doing a post on: " + url + " with content: " + content);
        HttpPost request = new HttpPost(url);
        StringEntity entity = new StringEntity(content, this.getContentTypeForSubmittedData(), "UTF-8");
        request.setEntity((HttpEntity)entity);
        this.addDefaultHeaders((HttpMessage)request);
        this.executeRequest((HttpUriRequest)request);
    }

    public void httpPutRequest(String url, String content) throws Exception {
        LOG.info("doing a put on: " + url + " with content: " + content);
        HttpPut request = new HttpPut(url);
        StringEntity entity = new StringEntity(content, this.getContentTypeForSubmittedData(), "UTF-8");
        request.setEntity((HttpEntity)entity);
        this.addDefaultHeaders((HttpMessage)request);
        this.executeRequest((HttpUriRequest)request);
    }

    private String getContentTypeForSubmittedData() {
        return this.contentType != null ? this.contentType : this.responseParser.acceptedMimeType();
    }

    private void executeRequest(HttpUriRequest request) throws Exception {
        this.response = this.httpClient.execute(request, this.localContext);
        this.content = EntityUtils.toString((HttpEntity)this.response.getEntity());
        this.responseParser.parse(this.content);
    }

    public int statusCode() {
        this.assertResponse();
        return this.response.getStatusLine().getStatusCode();
    }

    public String contentType() {
        return this.header("Content-Type");
    }

    public String header(String header) {
        this.assertResponse();
        Header headerValue = this.response.getFirstHeader(header);
        return headerValue != null ? headerValue.getValue() : null;
    }

    public String content() {
        this.assertResponse();
        return this.content;
    }

    public boolean contentContains(String substring) {
        this.assertResponse();
        return this.content.contains(substring);
    }

    public Object path(String path) {
        this.assertResponse();
        Object valueOnPath = this.responseParser.getValue(path);
        LOG.info(this.responseParser.getClass().getName() + " got value: " + valueOnPath + " on path: " + path);
        return valueOnPath;
    }

    public int pathCount(String path) {
        this.assertResponse();
        return this.responseParser.getCount(path);
    }

    private void assertResponse() {
        if (this.response == null) {
            throw new AssertionError((Object)"First perform a Http GET or POST request");
        }
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

