/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.io.InputClosedException;
import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputShop;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class DisconnectingInputShop<E extends Entry>
extends DecoratingInputShop<E, InputShop<E>> {
    private boolean closed;

    public DisconnectingInputShop(InputShop<E> input) {
        super(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            ((InputShop)this.delegate).close();
        }
        finally {
            this.closed = true;
        }
    }

    private void assertNotClosed() throws IOException {
        if (this.closed) {
            throw new InputClosedException();
        }
    }

    @Override
    public InputSocket<? extends E> getInputSocket(final String name) {
        if (null == name) {
            throw new NullPointerException();
        }
        class Input
        extends DecoratingInputSocket<E> {
            Input() {
                super(DisconnectingInputShop.super.getInputSocket(string));
            }

            @Override
            public ReadOnlyFile newReadOnlyFile() throws IOException {
                DisconnectingInputShop.this.assertNotClosed();
                return new DisconnectableReadOnlyFile(this.getBoundSocket().newReadOnlyFile());
            }

            @Override
            public InputStream newInputStream() throws IOException {
                DisconnectingInputShop.this.assertNotClosed();
                return new DisconnectableInputStream(this.getBoundSocket().newInputStream());
            }
        }
        return new Input();
    }

    private final class DisconnectableInputStream
    extends DecoratingInputStream {
        DisconnectableInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            DisconnectingInputShop.this.assertNotClosed();
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            DisconnectingInputShop.this.assertNotClosed();
            return this.delegate.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            DisconnectingInputShop.this.assertNotClosed();
            return this.delegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            DisconnectingInputShop.this.assertNotClosed();
            return this.delegate.available();
        }

        @Override
        public void mark(int readlimit) {
            if (!DisconnectingInputShop.this.closed) {
                this.delegate.mark(readlimit);
            }
        }

        @Override
        public void reset() throws IOException {
            DisconnectingInputShop.this.assertNotClosed();
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return !DisconnectingInputShop.this.closed && this.delegate.markSupported();
        }

        @Override
        public void close() throws IOException {
            if (DisconnectingInputShop.this.closed) {
                return;
            }
            this.delegate.close();
        }
    }

    private final class DisconnectableReadOnlyFile
    extends DecoratingReadOnlyFile {
        DisconnectableReadOnlyFile(ReadOnlyFile rof) {
            super(rof);
        }

        @Override
        public long length() throws IOException {
            DisconnectingInputShop.this.assertNotClosed();
            return this.delegate.length();
        }

        @Override
        public long getFilePointer() throws IOException {
            DisconnectingInputShop.this.assertNotClosed();
            return this.delegate.getFilePointer();
        }

        @Override
        public void seek(long pos) throws IOException {
            DisconnectingInputShop.this.assertNotClosed();
            this.delegate.seek(pos);
        }

        @Override
        public int read() throws IOException {
            DisconnectingInputShop.this.assertNotClosed();
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            DisconnectingInputShop.this.assertNotClosed();
            return this.delegate.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            if (DisconnectingInputShop.this.closed) {
                return;
            }
            this.delegate.close();
        }
    }
}

