/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key.pbe.swing;

import de.schlichtherle.truezip.crypto.param.KeyStrength;
import de.schlichtherle.truezip.swing.EnhancedPanel;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public class KeyStrengthPanel<S extends KeyStrength>
extends EnhancedPanel {
    private static final long serialVersionUID = 5629581723148235643L;
    private static final ResourceBundle resources = ResourceBundle.getBundle(KeyStrengthPanel.class.getName());
    private final S[] availableKeyStrengths;
    private final JComboBox keyStrength = new JComboBox();

    public KeyStrengthPanel(S[] availableKeyStrenghts) {
        this.availableKeyStrengths = (KeyStrength[])availableKeyStrenghts.clone();
        this.initComponents();
    }

    private ComboBoxModel<S> newModel() {
        return new DefaultComboBoxModel<S>(this.availableKeyStrengths);
    }

    private void initComponents() {
        JLabel keyStrengthLong = new JLabel();
        JLabel keyStrengthShort = new JLabel();
        this.setLayout(new GridBagLayout());
        this.keyStrength.setModel(this.newModel());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.keyStrength, gridBagConstraints);
        keyStrengthLong.setLabelFor(this.keyStrength);
        keyStrengthLong.setText(resources.getString("prompt"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add(keyStrengthLong, gridBagConstraints);
        keyStrengthShort.setLabelFor(this.keyStrength);
        keyStrengthShort.setText(resources.getString("keyStrength"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.add(keyStrengthShort, gridBagConstraints);
    }

    public S getKeyStrength() {
        return (S)((KeyStrength)this.keyStrength.getSelectedItem());
    }

    public void setKeyStrength(S keyStrength) {
        if (null == keyStrength) {
            throw new NullPointerException();
        }
        this.keyStrength.setSelectedItem(keyStrength);
    }
}

