/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.cache.MruCacheStorage;
import freemarker.core.BuiltIn;
import freemarker.core.Environment;
import freemarker.log.Logger;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

abstract class RegexBuiltins {
    private static final Logger logger = Logger.getLogger("freemarker.runtime");
    private static volatile boolean flagWarningsEnabled = logger.isWarnEnabled();
    private static final int MAX_FLAG_WARNINGS_LOGGED = 25;
    private static final Object flagWarningsCntSync = new Object();
    private static int flagWarningsCnt;
    static final MruCacheStorage patternCache;
    private static final long RE_FLAG_CASE_INSENSITIVE;
    private static final long RE_FLAG_MULTILINE;
    private static final long RE_FLAG_COMMENTS;
    private static final long RE_FLAG_DOTALL;
    private static final long RE_FLAG_REGEXP = 0x100000000L;
    private static final long RE_FLAG_FIRST_ONLY = 0x200000000L;

    RegexBuiltins() {
    }

    private static long intFlagToLong(int flag) {
        return (long)flag & 0xFFFFL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Pattern getPattern(String patternString, int flags) throws TemplateModelException {
        Pattern result;
        PatternCacheKey patternKey = new PatternCacheKey(patternString, flags);
        MruCacheStorage mruCacheStorage = patternCache;
        synchronized (mruCacheStorage) {
            result = (Pattern)patternCache.get(patternKey);
        }
        if (result != null) {
            return result;
        }
        try {
            result = Pattern.compile(patternString, flags);
        }
        catch (PatternSyntaxException e) {
            throw new TemplateModelException(e);
        }
        mruCacheStorage = patternCache;
        synchronized (mruCacheStorage) {
            patternCache.put(patternKey, result);
        }
        return result;
    }

    private static long parseFlagString(String flagString) {
        long flags = 0L;
        block8: for (int i = 0; i < flagString.length(); ++i) {
            char c = flagString.charAt(i);
            switch (c) {
                case 'i': {
                    flags |= RE_FLAG_CASE_INSENSITIVE;
                    continue block8;
                }
                case 'm': {
                    flags |= RE_FLAG_MULTILINE;
                    continue block8;
                }
                case 'c': {
                    flags |= RE_FLAG_COMMENTS;
                    continue block8;
                }
                case 's': {
                    flags |= RE_FLAG_DOTALL;
                    continue block8;
                }
                case 'r': {
                    flags |= 0x100000000L;
                    continue block8;
                }
                case 'f': {
                    flags |= 0x200000000L;
                    continue block8;
                }
                default: {
                    if (!flagWarningsEnabled) continue block8;
                    RegexBuiltins.logFlagWarning("Unrecognized regular expression flag: " + StringUtil.jQuote(String.valueOf(c)) + ".");
                }
            }
        }
        return flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logFlagWarning(String message) {
        int cnt;
        if (!flagWarningsEnabled) {
            return;
        }
        Object object = flagWarningsCntSync;
        synchronized (object) {
            cnt = flagWarningsCnt++;
            if (cnt >= 25) {
                flagWarningsEnabled = false;
                return;
            }
        }
        message = message + " This will be an error in FreeMarker 2.4!";
        if (cnt + 1 == 25) {
            message = message + " [Will not log more regular expression flag problems until restart!]";
        }
        logger.warn(message);
    }

    private static void checkNonRegexpFlags(String biName, long flags) {
        if (!flagWarningsEnabled) {
            return;
        }
        if ((flags & RE_FLAG_MULTILINE) != 0L) {
            RegexBuiltins.logFlagWarning("?" + biName + " doesn't support the \"m\" flag " + "without the \"r\" flag.");
        }
        if ((flags & RE_FLAG_DOTALL) != 0L) {
            RegexBuiltins.logFlagWarning("?" + biName + " doesn't support the \"s\" flag " + "without the \"r\" flag.");
        }
        if ((flags & RE_FLAG_COMMENTS) != 0L) {
            RegexBuiltins.logFlagWarning("?" + biName + " doesn't support the \"c\" flag " + "without the \"r\" flag.");
        }
    }

    static {
        patternCache = new MruCacheStorage(50, 150);
        RE_FLAG_CASE_INSENSITIVE = RegexBuiltins.intFlagToLong(2);
        RE_FLAG_MULTILINE = RegexBuiltins.intFlagToLong(8);
        RE_FLAG_COMMENTS = RegexBuiltins.intFlagToLong(4);
        RE_FLAG_DOTALL = RegexBuiltins.intFlagToLong(32);
    }

    static class SplitMethod
    implements TemplateMethodModel {
        private String s;

        SplitMethod(String s) {
            this.s = s;
        }

        public Object exec(List args) throws TemplateModelException {
            int numArgs = args.size();
            if (numArgs < 1 || numArgs > 2) {
                throw new TemplateModelException("?replace(...) needs 1 or 2 arguments.");
            }
            String splitString = (String)args.get(0);
            long flags = numArgs > 1 ? RegexBuiltins.parseFlagString((String)args.get(1)) : 0L;
            String[] result = null;
            if ((flags & 0x100000000L) == 0L) {
                RegexBuiltins.checkNonRegexpFlags("split", flags);
                result = StringUtil.split(this.s, splitString, (flags & RE_FLAG_CASE_INSENSITIVE) != 0L);
            } else {
                Pattern pattern = RegexBuiltins.getPattern(splitString, (int)flags);
                result = pattern.split(this.s);
            }
            return ObjectWrapper.DEFAULT_WRAPPER.wrap(result);
        }
    }

    static class ReplaceMethod
    implements TemplateMethodModel {
        private String s;

        ReplaceMethod(String s) {
            this.s = s;
        }

        public Object exec(List args) throws TemplateModelException {
            String result;
            long flags;
            int numArgs = args.size();
            if (numArgs < 2 || numArgs > 3) {
                throw new TemplateModelException("?replace(...) needs 2 or 3 arguments.");
            }
            String arg1 = (String)args.get(0);
            String arg2 = (String)args.get(1);
            long l = flags = numArgs > 2 ? RegexBuiltins.parseFlagString((String)args.get(2)) : 0L;
            if ((flags & 0x100000000L) == 0L) {
                RegexBuiltins.checkNonRegexpFlags("replace", flags);
                result = StringUtil.replace(this.s, arg1, arg2, (flags & RE_FLAG_CASE_INSENSITIVE) != 0L, (flags & 0x200000000L) != 0L);
            } else {
                Pattern pattern = RegexBuiltins.getPattern(arg1, (int)flags);
                Matcher matcher = pattern.matcher(this.s);
                result = (flags & 0x200000000L) != 0L ? matcher.replaceFirst(arg2) : matcher.replaceAll(arg2);
            }
            return new SimpleScalar(result);
        }
    }

    static class MatcherBuilder
    implements TemplateMethodModel {
        String matchString;

        MatcherBuilder(TemplateScalarModel match) throws TemplateModelException {
            this.matchString = match.getAsString();
        }

        public Object exec(List args) throws TemplateModelException {
            long flags;
            int numArgs = args.size();
            if (numArgs == 0) {
                throw new TemplateModelException("Expecting at least one argument");
            }
            if (numArgs > 2) {
                throw new TemplateModelException("Expecting at most two argumnets");
            }
            String patternString = (String)args.get(0);
            long l = flags = numArgs > 1 ? RegexBuiltins.parseFlagString((String)args.get(1)) : 0L;
            if ((flags & 0x200000000L) != 0L) {
                RegexBuiltins.logFlagWarning("?match doesn't support the \"f\" flag.");
            }
            Pattern pattern = RegexBuiltins.getPattern(patternString, (int)flags);
            Matcher matcher = pattern.matcher(this.matchString);
            return new RegexMatchModel(matcher, this.matchString);
        }
    }

    static class RegexMatchModel
    implements TemplateBooleanModel,
    TemplateCollectionModel,
    TemplateSequenceModel {
        final Matcher matcher;
        final String input;
        final boolean matches;
        TemplateSequenceModel groups;
        private ArrayList data;

        RegexMatchModel(Matcher matcher, String input) {
            this.matcher = matcher;
            this.input = input;
            this.matches = matcher.matches();
        }

        public boolean getAsBoolean() {
            return this.matches;
        }

        public TemplateModel get(int i) throws TemplateModelException {
            if (this.data == null) {
                this.initSequence();
            }
            return (TemplateModel)this.data.get(i);
        }

        public int size() throws TemplateModelException {
            if (this.data == null) {
                this.initSequence();
            }
            return this.data.size();
        }

        private void initSequence() throws TemplateModelException {
            this.data = new ArrayList();
            TemplateModelIterator it = this.iterator();
            while (it.hasNext()) {
                this.data.add(it.next());
            }
        }

        public TemplateModel getGroups() {
            if (this.groups == null) {
                this.groups = new TemplateSequenceModel(){

                    public int size() throws TemplateModelException {
                        try {
                            return RegexMatchModel.this.matcher.groupCount() + 1;
                        }
                        catch (Exception e) {
                            throw new TemplateModelException(e);
                        }
                    }

                    public TemplateModel get(int i) throws TemplateModelException {
                        try {
                            return new SimpleScalar(RegexMatchModel.this.matcher.group(i));
                        }
                        catch (Exception e) {
                            throw new TemplateModelException(e);
                        }
                    }
                };
            }
            return this.groups;
        }

        public TemplateModelIterator iterator() {
            this.matcher.reset();
            return new TemplateModelIterator(){
                boolean hasFindInfo;
                {
                    this.hasFindInfo = RegexMatchModel.this.matcher.find();
                }

                public boolean hasNext() {
                    return this.hasFindInfo;
                }

                public TemplateModel next() throws TemplateModelException {
                    if (!this.hasNext()) {
                        throw new TemplateModelException("No more matches");
                    }
                    Match result = new Match();
                    this.hasFindInfo = RegexMatchModel.this.matcher.find();
                    return result;
                }
            };
        }

        class Match
        implements TemplateScalarModel {
            String match;
            SimpleSequence subs = new SimpleSequence();

            Match() {
                this.match = RegexMatchModel.this.input.substring(RegexMatchModel.this.matcher.start(), RegexMatchModel.this.matcher.end());
                for (int i = 0; i < RegexMatchModel.this.matcher.groupCount() + 1; ++i) {
                    this.subs.add(RegexMatchModel.this.matcher.group(i));
                }
            }

            public String getAsString() {
                return this.match;
            }
        }
    }

    static class split_reBI
    extends BuiltIn {
        split_reBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateScalarModel) {
                return new SplitMethod(((TemplateScalarModel)model).getAsString());
            }
            throw split_reBI.invalidTypeException(model, this.target, env, "string");
        }
    }

    static class replace_reBI
    extends BuiltIn {
        replace_reBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateScalarModel) {
                return new ReplaceMethod(((TemplateScalarModel)model).getAsString());
            }
            throw replace_reBI.invalidTypeException(model, this.target, env, "string");
        }
    }

    static class groupsBI
    extends BuiltIn {
        groupsBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel targetModel = this.target.getAsTemplateModel(env);
            groupsBI.assertNonNull(targetModel, this, env);
            if (targetModel instanceof RegexMatchModel) {
                return ((RegexMatchModel)targetModel).getGroups();
            }
            if (targetModel instanceof RegexMatchModel.Match) {
                return ((RegexMatchModel.Match)targetModel).subs;
            }
            throw groupsBI.invalidTypeException(targetModel, this.target, env, "a regular expression matcher");
        }
    }

    static class matchesBI
    extends BuiltIn {
        matchesBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel targetModel = this.target.getAsTemplateModel(env);
            matchesBI.assertNonNull(targetModel, this, env);
            if (!(targetModel instanceof TemplateScalarModel)) {
                throw matchesBI.invalidTypeException(targetModel, this.target, env, "string");
            }
            return new MatcherBuilder((TemplateScalarModel)targetModel);
        }
    }

    private static class PatternCacheKey {
        private final String patternString;
        private final int flags;
        private final int hashCode;

        public PatternCacheKey(String patternString, int flags) {
            this.patternString = patternString;
            this.flags = flags;
            this.hashCode = patternString.hashCode() + 31 * flags;
        }

        public boolean equals(Object that) {
            if (that instanceof PatternCacheKey) {
                PatternCacheKey thatPCK = (PatternCacheKey)that;
                return thatPCK.flags == this.flags && thatPCK.patternString.equals(this.patternString);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

