/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.CatchAllMultiParameterFunction;
import com.github.sommeri.less4j.core.compiler.expressions.TypesConversionUtils;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.List;

class Unit
extends CatchAllMultiParameterFunction {
    private TypesConversionUtils conversionUtils = new TypesConversionUtils();

    Unit() {
    }

    @Override
    protected Expression evaluate(List<Expression> splitParameters, ProblemsHandler problemsHandler, HiddenTokenAwareTree token) {
        NumberExpression.Dimension newDimension;
        String newSuffix;
        String unit;
        NumberExpression dimension = (NumberExpression)splitParameters.get(0);
        String string = unit = splitParameters.size() > 1 ? this.conversionUtils.contentToString(splitParameters.get(1)) : null;
        if (unit != null) {
            newSuffix = unit;
            newDimension = NumberExpression.Dimension.forSuffix(newSuffix);
        } else {
            newSuffix = "";
            newDimension = NumberExpression.Dimension.NUMBER;
        }
        return new NumberExpression(token, dimension.getValueAsDouble(), newSuffix, null, newDimension);
    }

    @Override
    protected int getMinParameters() {
        return 1;
    }

    @Override
    protected int getMaxParameters() {
        return 2;
    }

    @Override
    protected boolean validateParameter(Expression parameter, int position, ProblemsHandler problemsHandler) {
        switch (position) {
            case 0: {
                return this.validateParameterTypeReportError(parameter, problemsHandler, ASTCssNodeType.NUMBER);
            }
            case 1: {
                return this.validateParameterTypeReportError(parameter, problemsHandler, ASTCssNodeType.IDENTIFIER_EXPRESSION, ASTCssNodeType.STRING_EXPRESSION, ASTCssNodeType.ESCAPED_VALUE);
            }
        }
        return false;
    }

    @Override
    protected String getName() {
        return "unit";
    }
}

