'use strict';angular.module('XLTest',['ngCookies','ngRoute','ngSanitize','restangular','XLPlatform.metadata','XLPlatform.sse','XLPlatform.filters','XLTest.security','XLTest.testsets','XLTest.testruns','XLTest.stores','XLTest.reports','XLTest.listeners','XLTest.directives']).value('REPORT_REF_BASE','/reports/').config(function($routeProvider,RestangularProvider){RestangularProvider.setBaseUrl('/xltest');RestangularProvider.setRequestInterceptor(function(elem,operation){if(operation==='remove'){return null;}
return elem;});RestangularProvider.setEncodeIds(false);Highcharts.setOptions({global:{useUTC:false}});$routeProvider.when('/testruns',{templateUrl:'partials/testruns.html',controller:'TestRuns'}).when('/testruns/new/:testSetId',{templateUrl:'partials/newtestrun.html',controller:'NewTestRun'}).when('/testruns/:testRunId',{templateUrl:'partials/testrunprogress.html',controller:'TestRunProgress'}).when('/reports/:testRunId/:reportId*',{templateUrl:'partials/openreport.html',controller:'OpenReport'}).when('/testsets',{templateUrl:'partials/testsets.html',controller:'TestSets'}).when('/testsets/new',{templateUrl:'partials/edittestset.html',controller:'EditTestSet'}).when('/testsets/:testSetId',{templateUrl:'partials/edittestset.html',controller:'EditTestSet'}).when('/stores/',{templateUrl:'partials/stores.html',controller:'Stores'}).when('/stores/new',{templateUrl:'partials/editstore.html',controller:'EditStore'}).when('/stores/:storeId',{templateUrl:'partials/editstore.html',controller:'EditStore'}).when('/listeners/',{templateUrl:'partials/listeners.html',controller:'Listeners'}).when('/listeners/new',{templateUrl:'partials/editlistener.html',controller:'EditListener'}).when('/listeners/:listenerId',{templateUrl:'partials/editlistener.html',controller:'EditListener'}).when('/reports/',{templateUrl:'partials/reports.html',controller:'Reports'}).when('/reports/new',{templateUrl:'partials/editreport.html',controller:'EditReport'}).when('/reports/:reportId',{templateUrl:'partials/editreport.html',controller:'EditReport'}).otherwise({redirectTo:'/testsets'});});'use strict';angular.module('XLPlatform.filters',[]).filter('duration',function(){return function(endDate,startDate){var end=Date.parse(endDate);var start=Date.parse(startDate);var milliseconds=end-start;var seconds=Math.floor(milliseconds/1000);var minutes=Math.floor(seconds/60);var hours=Math.floor(minutes/60);minutes=minutes%60;seconds=seconds%60;return(hours<10?'0':'')+hours+':'+
(minutes<10?'0':'')+minutes+':'+
(seconds<10?'0':'')+seconds;};}).filter('ciname',function(){return function(id){if(!id){return'';}
var parts=id.split('/');return parts[parts.length-1];};});'use strict';angular.module('XLPlatform.metadata',['restangular']).factory('metaDataService',function(Restangular){return Restangular.all('metadata/type');}).factory('dataService',function(Restangular){return Restangular.all('data');}).directive('xlListOfString',function(){return{restrict:'A',require:'ngModel',link:function(scope,element,attrs,ngModel){ngModel.$formatters.push(function(value){return value?_(value).join(', '):'';});ngModel.$parsers.push(function(value){return value?_.map(value.split(','),function(s){return s.trim();}):[];});}};}).directive('xlCi',function(dataService){return{restrict:'A',require:'ngModel',template:'<select ng-model="ngModel" ng-required="type.required" class="form-control" id="{{id}}" ng-options="def.id as def.id for def in cis"></select>',scope:{id:'@',type:'=',ngModel:'='},link:function(scope,element,attrs,ngModel){dataService.getList({'type':scope.type.referencedKind}).then(function(cis){scope.cis=cis;},function(){scope.cis=[];});}};}).directive('xlListOfCi',function(dataService){return{restrict:'A',template:'<p class="form-control" ng-repeat="ci in ngModel track by $index">'+'<span class="tag-label" ng-bind="ci"></span>'+'<span class="options"><a class="remove-icon" ng-click="remove($index)"></a></span>'+'</p>'+'<select class="form-control" ng-model="newEntry" id="{{id}}" ng-options="def.id as def.id for def in cis"></select>',require:'ngModel',scope:{id:'@',type:'=',ngModel:'='},link:function(scope,element,attrs,ngModel){var unique=attrs.unique==='true';scope.remove=function(index){scope.ngModel=scope.ngModel.slice(0,index).concat(scope.ngModel.slice(index+1));};scope.$watch('newEntry',function(){if(!scope.ngModel){scope.ngModel=[];}
if(scope.newEntry&&!(unique&&_.contains(scope.ngModel,scope.newEntry))){scope.ngModel.push(scope.newEntry);}
delete scope.newEntry;});dataService.getList({'type':scope.type.referencedKind}).then(function(cis){scope.cis=cis;},function(){scope.cis=[];});}};}).directive('xlMapStringString',function(dataService){return{restrict:'A',template:'<p class="form-control" ng-repeat="(key, value) in ngModel">'+'<span class="tag-label">{{key}}: {{value}}</span>'+'<span class="options"><a class="remove-icon" ng-click="remove(key)"></a></span>'+'</p>'+'<p>'+'<input type="text" class="form-control" style="display: inline; width:50%; border-right: none" ng-model="newKey" id="{{id}}" placeholder="enter a new key..."/>'+'<input type="text" class="form-control" style="display: inline; width:50%; border-left: none" ng-model="newValue" placeholder="... and its value"/>'+'</p>',require:'ngModel',scope:{id:'@',ngModel:'='},link:function(scope,element,attrs,ngModel){scope.remove=function(key){delete scope.ngModel[key];};var inputs=element.find('input');inputs.on('keypress',function(event){if(event.keyCode===13){console.log('Enter key',scope.newKey,scope.newValue);if(scope.newKey&&scope.newValue){if(!scope.ngModel){scope.ngModel={};}
scope.ngModel[scope.newKey]=scope.newValue;delete scope.newKey;delete scope.newValue;inputs[0].focus();}
event.preventDefault();scope.$digest();}})}};}).directive('dip',function(metaDataService){return{restrict:'E',templateUrl:'partials/dip.html',scope:{type:'@',model:'='},link:function(scope,element,attrs){var currentType=scope.selectedType;scope.prefix=attrs.prefix||'dip';var sticky=(attrs.sticky||'').split(',');scope.propertyFilter=function(p){return!p.hidden;};metaDataService.getList().then(function(metadata){var type=scope.type;scope.ciTypes=_.filter(metadata,function(metadatum){return(metadatum.type===type||_.contains(metadatum.extends,type))&&!metadatum.virtual;});if(scope.model&&scope.model.type){scope.selectedType=_.where(scope.ciTypes,{type:scope.model.type})[0];}},function(){console.log('unable to fetch metadata');});scope.$watch('model',function(){if(scope.model&&scope.model.type){scope.selectedType=_.where(scope.ciTypes,{type:scope.model.type})[0];}});scope.$watch('selectedType',function(){if(currentType&&scope.model.type){_(currentType.properties).forEach(function(p){if(!_.contains(sticky,p.name)){delete scope.model[p.name];}});}
currentType=scope.selectedType;if(scope.selectedType){scope.model.type=scope.selectedType.type;_(scope.selectedType.properties).forEach(function(p){if(!scope.model[p.name]&&p.defaultValue){scope.model[p.name]=p.defaultValue;}});}});}};});'use strict';angular.module('XLPlatform.sse',[]).directive('serverSentEvents',function(){return{restrict:'A',scope:{closeCallback:'&close'},link:function(scope,element,attr){var source=attr.source;var eventType=attr.eventType||'event';var eventSource=new EventSource(source);eventSource.addEventListener(eventType,function(event){var data=angular.fromJson(event.data);console.log('Have a new event: ',data);var ts=new Date(data._ts).toLocaleTimeString();var type=data.type;element.append(ts+': '+type+' -> '+event.data+'<br/>');scrollToBottom();},false);eventSource.addEventListener('close',function(event){console.log('closing event source');eventSource.close();var data=event.data&&angular.fromJson(event.data);scope.closeCallback({data:data});scope.$digest();scrollToBottom();},false);function scrollToBottom(){var scrollMe=angular.element('body');scrollMe.scrollTop(scrollMe.prop('scrollHeight'));}}};});'use strict';angular.module('XLTest.directives',[]).value('REPORT_REF_BASE','/').directive('highchart',function($location,REPORT_REF_BASE){return{restrict:'E',template:'<div></div>',scope:{config:'='},replace:true,link:function(scope,element,attrs){scope.$watch('config',function(){var chartConfig;if(scope.config.plotOptions&&scope.config.plotOptions.series&&scope.config.plotOptions.series.point&&scope.config.plotOptions.series.point.events){chartConfig=_.clone(scope.config,true);chartConfig.plotOptions.series.point.events=_.mapValues(scope.config.plotOptions.series.point.events,function(val,key){if(val==='url'){return function(){var url=this.options[val];if(url){console.log('Loading report from',REPORT_REF_BASE+url);$location.path(REPORT_REF_BASE+url);scope.$apply();}};}else{return function(){alert(key+": "+this.options.y);}}});}else{chartConfig=scope.config;}
element.highcharts(chartConfig);});}};}).directive('reportRef',function(){return{restrict:'A',template:'<ng-include src="pageTemplate"></ng-include>',scope:{ref:'=reportRef'},controller:function($scope,$location,$window,Restangular){var queryParams=$location.search();$scope.$watch('ref',function(){if(!$scope.ref){return;}
console.log("Loading report for",$scope.ref);Restangular.one('reports').customGET($scope.ref.replace(/^\/+/,''),queryParams).then(function(response){console.log("Report output is: ",response);switch(response.type){case'rerun':$window.open(response.report);$scope.pageTemplate='partials/testrerun.html';$scope.new_run_url=response.report;break;default:$scope.pageTemplate='reports/'+response.type+'.html';$scope.report=response.report;break;}},function(response){console.log('Error in report response:',response);if(response.status!=404){alert('Failed to retrieve report on '+$scope.ref);}});});}};}).directive('innerHtml',function(){return{restrict:'A',scope:{html:'=innerHtml'},link:function(scope,element,attrs){element.html(scope.html);}};});'use strict';angular.module('XLTest.listeners',['restangular']).factory('listenersService',function(Restangular){return Restangular.all('data');}).controller('Listeners',function($scope,$location,listenersService){listenersService.getList({'type':'xltest.EventProcessor'}).then(function(listeners){$scope.listeners=listeners;},function(){$scope.listeners=[];});$scope.remove=function(listener){listener.remove().then(function(){$scope.listeners=_.without($scope.listeners,listener);});};}).controller('EditListener',function($scope,$location,$routeParams,listenersService,cinameFilter){$scope.listener={};$scope.inEditMode=false;if($routeParams.listenerId){listenersService.get('Configuration/Listeners/'+$routeParams.listenerId).then(function(listener){$scope.listener=listener;$scope.name=cinameFilter(listener.id);$scope.inEditMode=true;});}
$scope.add=function(){if($scope.inEditMode){$scope.listener.put();$location.path('/listeners');}else{listenersService.post($scope.listener).then(function(){console.log('Object saved OK');$location.path('/listeners');},function(){console.log('There was an error saving');});}};});'use strict';angular.module('XLTest.security',['restangular']).controller('Security',function($scope){$scope.userName=null;});'use strict';angular.module('XLTest.stores',['restangular']).factory('storesService',function(Restangular){return Restangular.all('data');}).controller('Stores',function($scope,$location,storesService){storesService.getList({'type':'xltest.Store'}).then(function(stores){$scope.stores=stores;},function(){$scope.stores=[];});$scope.remove=function(store){store.remove().then(function(){$scope.stores=_.without($scope.stores,store);});};}).controller('EditStore',function($scope,$location,$routeParams,storesService,cinameFilter){$scope.store={};$scope.inEditMode=false;if($routeParams.storeId){storesService.get('Configuration/Stores/'+$routeParams.storeId).then(function(store){$scope.store=store;$scope.name=cinameFilter(store.id);$scope.inEditMode=true;});}
$scope.add=function(){if($scope.inEditMode){$scope.store.put();$location.path('/stores');}else{storesService.post($scope.store).then(function(){console.log('Object saved OK');$location.path('/stores');},function(){console.log('There was an error saving');});}};});'use strict';angular.module('XLTest.testruns',['restangular']).factory('testRunsService',function(Restangular){return Restangular.all('test');}).controller('TestRuns',function($scope,testRunsService,Restangular,cinameFilter){testRunsService.getList().then(function(testRuns){$scope.testRuns=testRuns;_.forEach(testRuns,function(testRun){var testRunId=cinameFilter(testRun.id);Restangular.one('reports',testRunId).get().then(function(response){testRun.reports=response;},function(response){if(response.status!=404){alert('Failed to retrieve report');}});});},function(){$scope.testRuns=[];});}).controller('NewTestRun',function($scope,$routeParams,$location,testRunsService,cinameFilter){$scope.testRun={testSetDefinition:'Configuration/TestSetDefinitions/'+$routeParams.testSetId};$scope.run=function(){$scope.testRun.id="";testRunsService.post($scope.testRun).then(function(testRun){$location.path('/testruns/'+cinameFilter(testRun.id));});};}).controller('TestRunProgress',function($scope,$routeParams,testRunsService,Restangular){console.log('testRunProgress');$scope.testRunId=$routeParams.testRunId;$scope.testRunUrl='/xltest/test/'+$routeParams.testRunId;Restangular.one('reports',$routeParams.testRunId).get().then(function(response){$scope.reports=response;},function(response){if(response.status!=404){alert('Failed to retrieve report');}});$scope.done=false;$scope.isDone=function(data){console.log("isDone: ",data);$scope.done=true;$scope.finalReport='../test/'+$routeParams.testRunId;$scope.$digest();};$scope.stopTestRun=function(){console.log("Stop test run ",$routeParams.testRunId);testRunsService.all($scope.testRunId).post({type:'STOP'});};});'use strict';angular.module('XLTest.testsets',['restangular']).factory('testSetsService',function(Restangular){return Restangular.all('data');}).controller('TestSets',function($scope,$location,testSetsService){testSetsService.getList({'type':'xltest.TestSetDefinition'}).then(function(testSets){$scope.testSets=testSets;},function(){$scope.testSets=[];});$scope.remove=function(testSet){testSet.remove().then(function(){$scope.testSets=_.without($scope.testSets,testSet);});};}).controller('EditTestSet',function($scope,$location,$routeParams,testSetsService,cinameFilter){$scope.testSetDefinition={};$scope.inEditMode=false;if($routeParams.testSetId){testSetsService.get('Configuration/TestSetDefinitions/'+$routeParams.testSetId).then(function(testSet){$scope.testSetDefinition=testSet;$scope.name=cinameFilter(testSet.id);$scope.inEditMode=true;});}
$scope.add=function(){if($scope.inEditMode){$scope.testSetDefinition.put();$location.path('/testsets');}else{testSetsService.post($scope.testSetDefinition).then(function(){console.log('Object saved OK');$location.path('/testsets');},function(){console.log('There was an error saving');});}};});'use strict';angular.module('XLTest.reports',['restangular']).factory('reportsService',function(Restangular){return Restangular.all('data');}).controller('Reports',function($scope,$location,reportsService){reportsService.getList({'type':'xltest.Report'}).then(function(reports){$scope.reports=reports;},function(){$scope.reports=[];});$scope.remove=function(report){report.remove().then(function(){$scope.reports=_.without($scope.reports,report);});};}).controller('EditReport',function($scope,$location,$routeParams,reportsService,cinameFilter){$scope.report={};$scope.inEditMode=false;if($routeParams.reportId){reportsService.get('Configuration/Reports/'+$routeParams.reportId).then(function(report){$scope.report=report;$scope.name=cinameFilter(report.id);$scope.inEditMode=true;});}
$scope.add=function(){if($scope.inEditMode){$scope.report.put();$location.path('/reports');}else{reportsService.post($scope.report).then(function(){console.log('Object saved OK');$location.path('/reports');},function(){console.log('There was an error saving');});}};}).controller('OpenReport',function($scope,$routeParams,cinameFilter){var testRunId=$routeParams.testRunId;var reportId=$routeParams.reportId;$scope.reportUrl=cinameFilter(testRunId)+"/"+reportId;});