/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.NoSuchEventPropertyException;
import com.xebialabs.xltest.domain.TestRunId;
import com.xebialabs.xltest.service.EventDispatcher;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncEventDispatcher
extends EventDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncEventDispatcher.class);
    private ForkJoinPool executor = new ForkJoinPool(Runtime.getRuntime().availableProcessors(), ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true);
    private Multimap<TestRunId, Future<Void>> runningTasks = Multimaps.synchronizedMultimap((Multimap)LinkedListMultimap.create());

    @Override
    public void invokeEventHandler(final TestRunId testRunId, final EventHandler handler, final Event event) {
        if (event == null) {
            throw new IllegalArgumentException("Event may never be null");
        }
        ForkJoinTask<Void> task = ForkJoinTask.adapt(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    LOG.info("Invoking event for id " + testRunId + "; handler " + handler.getClass() + ": " + event);
                    handler.onReceive(event);
                }
                catch (NoSuchEventPropertyException e) {
                    LOG.info("Handler " + handler.getClass() + " gave up: " + e.getMessage());
                }
                catch (Throwable e) {
                    LOG.warn("Event handler threw event", e);
                }
                return null;
            }
        });
        this.runningTasks.put((Object)testRunId, task);
        this.executor.execute(task);
    }
}

