/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.utils;

import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Executor {
    private static final Logger LOG = LoggerFactory.getLogger((String)Executor.class.getName());
    public static final int MINUTE = 60000;

    public static int execute(Process process, int timeout) throws InterruptedException, TimeoutException {
        Worker worker = new Worker(process);
        worker.start();
        try {
            worker.join(timeout * 60000);
            if (worker.exit != null) {
                LOG.info("Worker process exited with code {}", (Object)worker.exit);
                int n = worker.exit;
                return n;
            }
            try {
                LOG.info("Worker timed out");
                throw new TimeoutException();
            }
            catch (InterruptedException ex) {
                LOG.info("Worker has been interrupted");
                worker.interrupt();
                Thread.currentThread().interrupt();
                throw ex;
            }
        }
        finally {
            LOG.info("Attempting to destroy the finished process {}", (Object)process);
            process.destroy();
            LOG.info("Worker process {} destroyed", (Object)process);
        }
    }

    private static class Worker
    extends Thread {
        private final Process process;
        private Integer exit;

        private Worker(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            try {
                LOG.info("waiting for process {} to finish", (Object)this.process);
                this.exit = this.process.waitFor();
            }
            catch (InterruptedException ignore) {
                LOG.info("process execution is interrupted");
                return;
            }
        }
    }
}

