/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.io;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.replacer.PlaceholderReplacer;
import com.xebialabs.deployit.engine.replacer.Placeholders;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderReplacer;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.overthere.local.LocalFile;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerivedArtifactFile {
    private static final Class<LocalFile> proxyClass = DerivedArtifactFile.createProxyClass();

    private static Class<LocalFile> createProxyClass() {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(LocalFile.class);
        proxyFactory.setUseCache(false);
        proxyFactory.setUseWriteReplace(false);
        return proxyFactory.createClass();
    }

    public static LocalFile create(DerivedArtifact artifact) {
        try {
            Constructor<LocalFile> constructor = proxyClass.getConstructor(LocalConnection.class, File.class);
            LocalFile o = constructor.newInstance(LocalConnection.getLocalConnection(), null);
            ((ProxyObject)o).setHandler(DerivedArtifactFile.getMethodHandler(artifact));
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create a proxy.", e);
        }
    }

    private static MethodHandler getMethodHandler(DerivedArtifact artifact) {
        return new DerivedFileHandler(artifact);
    }

    public static class DerivedFileHandler
    implements MethodHandler,
    Serializable {
        private static final Logger logger = LoggerFactory.getLogger(DerivedFileHandler.class);
        private DerivedArtifact artifact;

        public DerivedFileHandler(DerivedArtifact artifact) {
            this.artifact = artifact;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
            if (ProxyFactory.isProxyClass(this.artifact.getFile().getClass())) {
                Checks.checkArgument(this.artifact.getSourceArtifact() != null, "%s should have a source artifact.", this.artifact.getId());
                Checks.checkArgument(this.artifact.getSourceArtifact().getFile() != null, "Source artifact %s of %s should have a file set.", this.artifact.getId(), this.artifact.getSourceArtifact().getId());
                if (thisMethod.getName().equals("getName")) {
                    return this.artifact.getSourceArtifact().getFile().getName();
                }
                if (thisMethod.getName().equals("exists")) {
                    return true;
                }
                if (thisMethod.getName().equals("isFile")) {
                    return !(this.artifact.getSourceArtifact() instanceof FolderArtifact);
                }
                if (thisMethod.getName().equals("isDirectory")) {
                    return this.artifact.getSourceArtifact() instanceof FolderArtifact;
                }
                long startTimeStamp = System.currentTimeMillis();
                try {
                    Placeholders.replacePlaceholders((DerivedArtifact)this.artifact, (PlaceholderReplacer)new PlaceholderReplacer(){

                        public void replace(Reader in, Writer out, Map<String, String> resolution) {
                            new MustachePlaceholderReplacer(resolution).replace(in, out);
                        }

                        public void replace(Reader in, Writer out, Map<String, String> resolution, String delimiters) {
                            new MustachePlaceholderReplacer(resolution).replace(in, out, delimiters);
                        }
                    });
                }
                finally {
                    long endTimeStamp = System.currentTimeMillis();
                    logger.trace("Replacing placeholders in [{}] took [{}] millis", (Object)this.artifact, (Object)(endTimeStamp - startTimeStamp));
                }
            }
            return thisMethod.invoke((Object)this.artifact.getFile(), args);
        }
    }
}

